h48602
s 00003/00009/00126
d D 1.7 00/08/26 19:52:49 nitehawk 8 7
c convert all logging calls into logmsg
cC
cK53798
e
s 00000/00000/00135
d D 1.6 00/07/30 13:08:24 nitehawk 7 6
c Rename: koalamod/moduleops.c -> lib/koalamod/moduleops.c
cC
cK51928
cPlib/koalamod/moduleops.c
e
s 00000/00000/00135
d D 1.5 00/07/30 08:54:17 nitehawk 6 5
c Rename: lib/koala/moduleops.c -> lib/koalamod//moduleops.c
cC
cHlocalhost.1ststep.net
cK30236
cPkoalamod//moduleops.c
cZ-07:00
e
s 00001/00000/00134
d D 1.4 00/03/13 06:50:12 nitehawk 5 4
c Fix bad initialization of nullmodule definition
cC
cHparanor.1ststep.net
cK61871
cZ+00:00
e
s 00104/00000/00030
d D 1.3 00/03/12 21:44:39 nitehawk 4 3
c Add functions to startup/linkup/shutdown arrays of modules
cC
cK60446
e
s 00001/00000/00029
d D 1.2 00/03/12 10:15:18 nitehawk 3 2
c Add include of module.h
cK39062
e
s 00029/00000/00000
d D 1.1 00/03/12 10:12:58 nitehawk 2 1
cF1
cK37381
cO-rw-r--r--
e
s 00000/00000/00000
d D 1.0 00/03/12 10:12:58 nitehawk 1 0
c BitKeeper file /usr/home/nitehawk/koalamud/lib/koala/moduleops.c
cBnitehawk@paranor.1ststep.net|ChangeSet|19991214032450|08172|1f723a0b4571218e
cHwinghove.1ststep.net
cK65296
cPlib/koala/moduleops.c
cRfe4a020fd5b4e8c
cV3
cX0xa1
cZ-08:00
c______________________________________________________________________
e
u
U
f e 0
f x 0xa1
t
T
I 2
/* %Z% %M% %I% %Z% */
/***************************************************************\
*	Copyright (c) 1999 First Step Internet Services, Inc.
*		All Rights Reserved
*	Distributed under the BSD Licenese
*
*	Module: MODULE
\***************************************************************/

#define _KOALAMUD_MODULEOPS_C "%Z% %K% %Z%"

#include "autoconf.h"

#include "version.h"
#include "koalatypes.h"
#include "log.h"
#include "memory.h"
#include "llist.h"
I 3
#include "module.h"
E 3

/* Setinel definition */
module_t nullmodule =
{
	NULL,
	NULL,
I 5
	MODSTATE_UNDEFINED,
E 5
	NULL,
	NULL,
	NULL
};

I 4
/* Loop through a list of modules and call the startup function for each */
int modstartup(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->startupfn()) != 0)
		{
D 8
			char buf[120];
			snprintf(buf, 120, "Error #%d starting %s module version %s.",
E 8
I 8
			logmsg(LOGERR, "Error #%d starting %s module version %s.",
E 8
					err, cur->name, cur->version);
D 8
			logerr(buf);
E 8
			(*errors)++;
		}
		cur = modlist[++i];
	}

	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

/* Loop through a list of modules and call the linkup function for each */
int modlinkup(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->linkupfn()) != 0)
		{
D 8
			char buf[120];
			snprintf(buf, 120, "Error #%d starting %s module version %s.",
E 8
I 8
			logmsg(LOGERR, "Error #%d linking %s module version %s.",
E 8
					err, cur->name, cur->version);
D 8
			logerr(buf);
E 8
			(*errors)++;
		}
		cur = modlist[++i];
	}

	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

/* Loop through a list of modules and call the shutdown function for each */
int modshutdown(pmodule modlist[], pmodule listend, int *num, int *errors)
{
	int i = 0;
	pmodule cur = modlist[i];
	int err;

	/* Loop until we match the listend */
	while (cur != listend)
	{
		(*num)++;

		/* Call the startup function - should return 0, anything else is
		 * 	an error */
		if ((err = cur->shutdownfn()) != 0)
		{
D 8
			char buf[120];
			snprintf(buf, 120, "Error #%d starting %s module version %s.",
E 8
I 8
			logmsg(LOGERR, "Error #%d stopping %s module version %s.",
E 8
					err, cur->name, cur->version);
D 8
			logerr(buf);
E 8
			(*errors)++;
		}
		cur = modlist[++i];
	}
	
	if (*errors <= *num)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}
E 4
E 2
I 1
E 1
