/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>
   Copyright (C) 1999, 2000 Montel Laurent <montell@club-internet.fr>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __kspread_dlg_conditional__
#define __kspread_dlg_conditional__

#include <kdialogbase.h>
#include <qwidget.h>

class QComboBox;
class KLineEdit;

class KSpreadCell;
class KSpreadStyle;
class KSpreadView;

#include "kspread_condition.h"

class KSpreadConditionalWidget : public QWidget
{
  Q_OBJECT
  
 public:
  KSpreadConditionalWidget( QWidget * parent = 0, const char * name = 0, WFlags fl = 0 );
  ~KSpreadConditionalWidget();

  QComboBox * m_condition_1;
  QComboBox * m_style_1;
  KLineEdit * m_firstValue_1;
  KLineEdit * m_secondValue_1;
  
  QComboBox * m_condition_2;
  QComboBox * m_style_2;
  KLineEdit * m_firstValue_2;
  KLineEdit * m_secondValue_2;
  
  QComboBox * m_condition_3;
  QComboBox * m_style_3;
  KLineEdit * m_firstValue_3;
  KLineEdit * m_secondValue_3;

 public slots:
  void slotTextChanged1( const QString & );
  void slotTextChanged2( const QString & );
  void slotTextChanged3( const QString & );
};


class KSpreadConditionalDlg : public KDialogBase
{
  Q_OBJECT
 public:
  KSpreadConditionalDlg( KSpreadView * parent, const char * name,
                         const QRect & marker );

  void init();

 public slots:
  void slotOk();

 protected:
  KSpreadView *              m_view;
  KSpreadConditionalWidget * m_dlg;
  QRect                      m_marker;
  KSpreadConditional         m_result;

 private:
  void init( KSpreadConditional const & tmp, int numCondition );
  Conditional typeOfCondition( QComboBox const * const cb ) const;

  bool checkInputData( KLineEdit const * const edit1,
                       KLineEdit const * const edit2 );
  bool checkInputData();
  bool getCondition( KSpreadConditional & newCondition, QComboBox const * const cb,
                     KLineEdit const * const edit1, KLineEdit const * const edit2,
                     QComboBox const * const sb, KSpreadStyle * style );

};

#endif

