/*******************************************************************************
**                         backupprofile.h
**                             part of
**                konserve -- A small backup application
**			 -------------------
**  copyright: (C) 2002 - 2004 by Florian Simnacher
**  email    : simnacher AT gmx DOT de
*******************************************************************************/

/*******************************************************************************
**  This program is free software; you can redistribute it and/or             **
**  modify it under the terms of the GNU General Public License               **
**  as published by the Free Software Foundation; either version 2            **
**  of the License, or (at your option) any later version.                    **
**                                                                            **
**  This program is distributed in the hope that it will be useful,           **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of            **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             **
**  GNU General Public License for more details.                              **
**                                                                            **
**  You should have received a copy of the GNU General Public License         **
**  along with this program; if not, write to the Free Software               **
**  Foundation, Inc., 59 Temple Place - Suite 330, Boston,                    **
**  MA  02111-1307, USA.                                                      **
*******************************************************************************/
#ifndef BACKUPPROFILE_H
#define BACKUPPROFILE_H

// Qt includes
#include <qdatetime.h>
#include <qstring.h>
#include <qtimer.h>
#include <qobject.h>

// KDE includes
#include <kurl.h>
#include <kio/job.h>
#include <kfileitem.h>

// My includes
#include "timeinterval.h"
#include "backup.h"

class KArchiveEntry;

////////////////////////////////////////////////////////////////////////////////
///////                  class BackupProfile                             ///////
////////////////////////////////////////////////////////////////////////////////

class BackupProfile : public QObject
{

    Q_OBJECT

public:
    BackupProfile( Backup*      impl,
                   QString      identifier,
                   TimeInterval interv,
                   QDateTime    last,
                   bool         activ,
                   bool         readonly = false );
    ~BackupProfile();

    void activate();
    bool isActivated() const
        { return mbIsActivated; }

    void setSourceUrl( KURL url )
        { mpBackup->setSourceUrl( url ); }
    KURL getSourceUrl() const
        { return mpBackup->getSourceUrl(); }

    void setArchiveUrl( KURL url )
        { mpBackup->setArchiveUrl( url ); }
    KURL getArchiveUrl() const
        { return mpBackup->getArchiveUrl(); }

    void setIdentifier( QString id )
        { mIdentifier = id; }
    QString getIdentifier() const
        { return mIdentifier; }

    void setTimeBetweenBackups( TimeInterval t )
        { mTimeToBackup = t; }
    TimeInterval getTimeBetweenBackups() const
        { return mTimeToBackup; }

    void setLastTime( QDateTime q )
        { mLastBackupTime = q; }
    QDateTime getLastTime() const
        { return mLastBackupTime; }

    void restore();

    static BackupProfile *newBackupProfile(
        KURL      source,
        KURL      backup,
        QString   identifier,
        int       time,
        QString   measurement,
        bool      activ,
        QDateTime last
        );

    static BackupProfile *newBackupProfileReadOnly(
        KURL      source,
        KURL      backup,
        QString   identifier,
        int       time,
        QString   measurement,
        bool      activ,
        QDateTime last
        );

    static BackupProfile *newBackupProfileReadOnly(
        const BackupProfile * const b
        );

public slots:
    void slotDoOneTimeBackup();
    void slotFinishedBackup( bool successful );

protected slots:
    void slotSearchForModifiedFiles(
        KIO::Job* aJob, const KIO::UDSEntryList& list
        );
    void slotFinishedSearchingModifiedFiles( KIO::Job* aJob );

private:
    BackupProfile( const BackupProfile& b );
    void operator=( const BackupProfile& );
    void setupTimer();
    void extractArchiveEntry( KArchiveEntry* entry, QString path );
    KURL getLatestBackup();
    bool restoreActionIsSave();
    void doBackupIfNeeded();

private:
    Backup            *mpBackup;
    QTimer            *mpTimer;

    QString            mIdentifier;
    TimeInterval       mTimeToBackup;
    QDateTime          mLastBackupTime;
    bool               mbIsActivated;
    bool               mbReadOnly;
    bool               mbFilesModified;
};

#endif
