#ifndef MENULISTVIEW_H_INCLUDED
#define MENULISTVIEW_H_INCLUDED

#include <qlistview.h>
#include <qpopupmenu.h>

/**
 * @short ListView with a right-click menu.
 * @author Billy Biggs <vektor@div8.net>
 *
 * MenuListView is an extension of QListView which provides a right-click
 * popup menu. The click handling and menu are provided by MenuListView.
 */
class MenuListView : public QListView
{
	Q_OBJECT
public:

	/**
	 * Constructs a MenuListView.
	 */
	MenuListView( QWidget *parent = 0, const char *name = 0 );

	/**
	 * Destructor for MenuListView.
	 */
	~MenuListView( void );

	/**
	 * Add an item to the menu with description @param desc, and
	 * and connect it to the provided slot.
	 */
	void addMenuItem( QString desc, const QObject *reciever,
		const char *member );

	/**
	 * Inserts a separator into the menu.
	 */
	void addMenuSeparator( void );

private slots:
	void showMenu( QListViewItem *curi, const QPoint& pos, int );

private:
	QPopupMenu *ops;
};

#endif // MENULISTVIEW_H_INCLUDED
