/***************************************************************************
                          devicesdlg.cpp  -  description
                             -------------------
    begin                : Wed Sep 27 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "devicesdlg.h"

#include "globals.h"

devicesDlg::devicesDlg(QWidget *parent, bool m, bool* c)
					 : KDialogBase(parent, "devicesDlg", true, i18n("Devices"), Ok|Cancel, Ok, true) {

	restartmessage=m;
	cancel=c;
	QGridLayout* grid;
	QWidget* w;
	QLabel* l;
	setWFlags (WDestructiveClose);

	w = new QWidget (this);
	setMainWidget (w);
	grid = new QGridLayout (w, 2, 2, 5, 5);

	audioEdit = new QLineEdit (w);
  l = new QLabel( audioEdit, i18n ("&Audio Device:"), w);
	grid->addWidget (l, 0, 0, Qt::AlignRight);
	grid->addWidget (audioEdit, 0, 1);

	PTTEdit = new QLineEdit (w);
  l = new QLabel( PTTEdit, i18n ("&PTT Device:"), w);
	grid->addWidget (l, 1, 0, Qt::AlignRight);
	grid->addWidget (PTTEdit, 1, 1);

	audioEdit->setText (config.psk31.audioDevice);
	PTTEdit->setText (config.psk31.pttDevice);	
}

devicesDlg::~devicesDlg()
{
}

void devicesDlg::slotOk()
{
	config.psk31.audioDevice=audioEdit->text();
	config.psk31.pttDevice=PTTEdit->text();
	hide();
	if (restartmessage)
		KMessageBox::information (this, i18n ("To activate changes, you'll have to restart KPSK"));
	KDialogBase::slotOk();
}

void devicesDlg::slotCancel()
{
	if (cancel!=NULL)
		*cancel=true;
	KDialogBase::slotCancel();
}
