#ifndef _KVI_SCRIPT_FILE_H_INCLUDED_
#define _KVI_SCRIPT_FILE_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_script_object.h"

class QFile;

class KviScriptFile : public KviScriptObject
{
	Q_OBJECT
public:
	KviScriptFile(KviScriptObjectController *, KviScriptObject *, const char *name, KviScriptObjectClassDefinition *);
	~KviScriptFile();
protected:
	QFile *m_pFile;
public:
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	bool init(QPtrList<KviStr> *params);

	int builtinFunction_SETFILENAME(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_FILENAME(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_OPEN(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_CLOSE(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_FLUSH(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_SIZE(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_EXISTS(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_REMOVE(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_ISEOF(QPtrList<KviStr> *params, KviStr &buffer);
	int         builtinFunction_POS(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_SEEK(QPtrList<KviStr> *params, KviStr &buffer);
	int       builtinFunction_WRITE(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_WRITEHEX(QPtrList<KviStr> *params, KviStr &buffer);
	int        builtinFunction_READ(QPtrList<KviStr> *params, KviStr &buffer);
	int     builtinFunction_READHEX(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_READLINE(QPtrList<KviStr> *params, KviStr &buffer);
};

#endif // _KVI_SCRIPT_FILE_H_INCLUDED_
