/***************************************************************************
                          kwcentryselection.cpp  -  description
                             -------------------
    begin                : Sam Feb 1 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentryselection.h"

KWCEntrySelection::KWCEntrySelection(const QString & inscr, int row, QWidget *parent, const char *name ) : KWCEntry(inscr, row, parent,name)
{
	valueSelect = new KComboBox(this);
	valueSelect->setGeometry(*rightWidgetRect);
	valueSelect->show();

	setValueWidget(valueSelect);
	
	connect(valueSelect, SIGNAL(activated(int)), this, SLOT(itemActivatedSlot(int)));
}

KWCEntrySelection::~KWCEntrySelection()
{
	
}

/** No descriptions */
void KWCEntrySelection::insertItem(const QString & text, int index)
{
	valueSelect->insertItem(text, index);
}

/** No descriptions */
void KWCEntrySelection::setCurrentItem(int index)
{
	valueSelect->setCurrentItem(index);
}

/** No descriptions */
void KWCEntrySelection::clear()
{
	valueSelect->clear();	
}
/** No descriptions */
void KWCEntrySelection::itemActivatedSlot(int index)
{
	activated(index);
}
