//LabPlot : SpreadsheetPropertiesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "SpreadsheetPropertiesDialog.h"

#include "spreadsheetProperties.h"

SpreadsheetPropertiesDialog::SpreadsheetPropertiesDialog(QTable *t, QString name)
	: Dialog(0, name),table(t)
{
	setCaption(i18n("Spreadsheet Properties")+i18n(" : ")+name);

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Label : "),hb);
	QString header = table->horizontalHeader()->label(table->currentColumn());
	QString label(header);
	// TODO : check format
	label.remove(QRegExp(" \\{.+\\]"));
	labelle =  new KLineEdit(label,hb);

	hb = new QHBox(vbox);
	new QLabel(i18n("Type : "),hb);
	typecb = new KComboBox(hb);
	typecb->insertStrList(columnTypeItems);
	
	// set current type
	int pos = header.find(QRegExp(" \\[.+\\]"));
	QString type = header.right(header.length()-pos-1);
	for(int i=0;i<NR_COLUMNTYPES;i++)
		if(type==typecb->text(i))
			typecb->setCurrentItem(i);

	hb = new QHBox(vbox);
	new QLabel(i18n("Format : "),hb);
	formatcb = new KComboBox(hb);
	formatcb->insertStrList(formatList);
	int pos1 = header.find(QRegExp("\\{"));
	int pos2 = header.find(QRegExp("\\}"));
	QString format = header.mid(pos1,pos2-pos1+1);
	for(int i=0;i<NR_FORMATS;i++)
		if(format==formatcb->text(i))
			formatcb->setCurrentItem(i);

	hb = new QHBox(vbox);
	new QLabel(i18n("Number of Rows : "),hb);
	rowle =  new KLineEdit(QString::number(table->numRows()),hb);
	rowle->setValidator(new QIntValidator(rowle));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	// vbox<gbox
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void SpreadsheetPropertiesDialog::apply_clicked() {
	table->setNumRows(rowle->text().toInt());
	table->horizontalHeader()->setLabel(table->currentColumn(),labelle->text() +' '+ 
		formatcb->currentText()+' '+typecb->currentText());
}
