.TH DLARRE l "15 June 2000" "LAPACK version 3.0" ")"
.SH NAME
DLARRE - the tridiagonal matrix T, DLARRE sets "small" off-diagonal elements to zero, and for each unreduced block T_i, it finds (i) the numbers sigma_i (ii) the base T_i - sigma_i I = L_i D_i L_i^T representations and (iii) eigenvalues of each L_i D_i L_i^T
.SH SYNOPSIS
.TP 19
SUBROUTINE DLARRE(
N, D, E, TOL, NSPLIT, ISPLIT, M, W, WOFF,
GERSCH, WORK, INFO )
.TP 19
.ti +4
INTEGER
INFO, M, N, NSPLIT
.TP 19
.ti +4
DOUBLE
PRECISION TOL
.TP 19
.ti +4
INTEGER
ISPLIT( * )
.TP 19
.ti +4
DOUBLE
PRECISION D( * ), E( * ), GERSCH( * ), W( * ), WOFF( * ),
WORK( * )
.SH PURPOSE
Given the tridiagonal matrix T, DLARRE sets "small" off-diagonal elements to zero, and for each unreduced block T_i, it finds (i) the numbers sigma_i (ii) the base T_i - sigma_i I = L_i D_i L_i^T representations and (iii) eigenvalues of each L_i D_i L_i^T. The representations and eigenvalues found are then used by
DSTEGR to compute the eigenvectors of a symmetric tridiagonal
matrix. Currently, the base representations are limited to being
positive or negative definite, and the eigenvalues of the definite
matrices are found by the dqds algorithm (subroutine DLASQ2). As
an added benefit, DLARRE also outputs the n Gerschgorin
.br
intervals for each L_i D_i L_i^T.
.br

.SH ARGUMENTS
.TP 8
N       (input) INTEGER
The order of the matrix.
.TP 8
D       (input/output) DOUBLE PRECISION array, dimension (N)
On entry, the n diagonal elements of the tridiagonal
matrix T.
On exit, the n diagonal elements of the diagonal
matrices D_i.
.TP 8
E       (input/output) DOUBLE PRECISION array, dimension (N)
On entry, the (n-1) subdiagonal elements of the tridiagonal
matrix T; E(N) need not be set.
On exit, the subdiagonal elements of the unit bidiagonal
matrices L_i.
.TP 8
TOL     (input) DOUBLE PRECISION
The threshold for splitting. If on input |E(i)| < TOL, then
the matrix T is split into smaller blocks.
.TP 8
NSPLIT  (input) INTEGER
The number of blocks T splits into. 1 <= NSPLIT <= N.
.TP 8
ISPLIT  (output) INTEGER array, dimension (2*N)
The splitting points, at which T breaks up into submatrices.
The first submatrix consists of rows/columns 1 to ISPLIT(1),
the second of rows/columns ISPLIT(1)+1 through ISPLIT(2),
etc., and the NSPLIT-th consists of rows/columns
ISPLIT(NSPLIT-1)+1 through ISPLIT(NSPLIT)=N.
.TP 8
M       (output) INTEGER
The total number of eigenvalues (of all the L_i D_i L_i^T)
found.
.TP 8
W       (output) DOUBLE PRECISION array, dimension (N)
The first M elements contain the eigenvalues. The
eigenvalues of each of the blocks, L_i D_i L_i^T, are
sorted in ascending order.
.TP 8
WOFF    (output) DOUBLE PRECISION array, dimension (N)
The NSPLIT base points sigma_i.
.TP 8
GERSCH  (output) DOUBLE PRECISION array, dimension (2*N)
The n Gerschgorin intervals.
.TP 8
WORK    (input) DOUBLE PRECISION array, dimension (4*N???)
Workspace.
.TP 8
INFO    (output) INTEGER
Output error code from DLASQ2
.SH FURTHER DETAILS
Based on contributions by
.br
   Inderjit Dhillon, IBM Almaden, USA
.br
   Osni Marques, LBNL/NERSC, USA
.br

