/*  Copyright 2001 Rien Croonenborghs, Ben Kibbey, Shaun Jackman

    This file is part of lcab.
    lcab is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    lcab is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    You should have received a copy of the GNU General Public License
    along with lcab; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "cfile.h"

// initialize the cabfile-structure
// set filesize
//     index
//     filename
void cfile_init( struct cfile *cf, int usize, int index, char *filename )
{
	int i;
	char year[4], month[3], day[2];
	char hour[2], minute[2], second[2];
	int jaar, maand, dag;
	int h, m, s;
	struct stat attributes;
	time_t tmp;
	char *lijn;

	cf->usize = usize;
	cf->index = index;
		stat(filename,&attributes);
		tmp=attributes.st_mtime;
		lijn=ctime(&tmp);
		for(i=0;i<4;++i) { *(year+i)=*(lijn+i+20); }
		for(i=0;i<3;++i) { *(month+i)=*(lijn+i+4); }
		for(i=0;i<2;++i) { *(day+i)=*(lijn+i+8); }
			jaar=atoi((const char *)year);
			dag=atoi((const char *)day); 
		// way too long source-code for 'converting' Apr->4, May->5, Jan->1 (you get the picture)
			if(month[0]=='J') { if(month[1]=='a') { maand=1;} else if(month[1]=='u') { if(month[2]=='n') { maand=6; } else maand=7; } }
			else if(month[0]=='F') { maand=2; }
			else if(month[0]=='M') { if(month[1]=='a') { if(month[2]=='r') maand=3; else maand=5; } }
			else if(month[0]=='A') { if(month[1]=='p') maand=4; else maand=8; }
			else if(month[0]=='S') maand=9;
			else if(month[0]=='O') maand=10;
			else if(month[0]=='N') maand=11;
			else if(month[0]=='D') maand=12;
	cf->date = ( ( jaar - 1980 ) << 9 ) + ( maand << 5 ) + ( dag ); 
		stat(filename,&attributes);
		tmp=attributes.st_mtime;
		lijn=ctime(&tmp);
		for(i=0;i<2;++i) { *(hour+i)=*(lijn+i+11); }
		for(i=0;i<2;++i) { *(minute+i)=*(lijn+i+14); }
		for(i=0;i<2;++i) { *(second+i)=*(lijn+i+17); }
			h=atoi((const char *)hour);
			m=atoi((const char *)minute);
			s=atoi((const char *)second);
	cf->time = ( h << 11 ) + ( m << 5 ) + ( s / 2 ); 
	cf->fattr = ATTR_e | ATTR_a;  
		for(i=0;i<strlen(filename);++i) { cf->name[i] = *(filename+i); } 
		cf->name[strlen(filename)] = STRINGTERM; 
}

// uncompressed offset where file resides in datablocks
void cfile_uoffset( struct cfile *cf, int offset ) 
{ 
	cf->uoffset = offset; 
}




