#!/bin/sh
# Run this to generate all the initial makefiles, etc.

srcdir=`dirname $0`
test -z "$srcdir" && srcdir=.

DIE=0

(autoconf --version $0) < /dev/null > /dev/null 2>&1 || {
        echo
        echo "You must have autoconf installed to compile lde."
        echo "Download the appropriate package for your distribution,"
        echo "or get the source tarball at ftp://ftp.gnu.org/pub/gnu/"
        DIE=1
}

if test "$DIE" -eq 1; then
        exit 1
fi

echo "Changing to macros/ and running  \"autoconf; ./configure $*\" ..."
cd $srcdir/macros

autoconf
rm -f config.*

if test -z "$*"; then
		echo
        echo "I am going to run ./configure with no arguments - if you wish "
        echo "to pass any to it, please specify them on the $0 command line."
		echo
fi

./configure "$@"


echo
echo "Now type 'make' to compile lde."

