# converts the selected text into a 'banner' style comment
# if no text is selected, it converts the whole buffer
# (C) 2001 Paul Evans <pevans@catholic.org> (under GPL)
# created from To_Lower.py

import string
import glimmer

def padhash(line):
    global longest
    spaces = ' ' * (longest - len(line))
    padded = "%s%s%s%s" % ('# ', line, spaces, ' #')
    return(padded)

if glimmer.has_selection():
    begin = glimmer.selection_start()
    end = glimmer.selection_end()
else:
    begin=0
    end= glimmer.buffer_size()
s = glimmer.get_text(begin,end)
glimmer.freeze()
glimmer.delete_text(begin,end)
glimmer.move_to(begin)


contentslist = string.split(s,'\n')
longest = 0
for i in contentslist:
    if len(i) > longest:
        longest = len(i)
x = '#'*(longest+4)
#x2 = '#' + ' '*(longest+2) + '#'
newlist = map(padhash, contentslist)
#newlist.insert(0, x2) #uncomment to have a blank leading line...
newlist.insert(0, x)
#newlist.append(x2)    #uncomment to have a blank trailing line...
newlist.append(x)
s = string.join(newlist, '\n')

glimmer.insert(s)
glimmer.thaw()
