#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include "../lcp3.h"
#include "cmd_lcp3.h"

void isdn_watcher()
{
    int position = 0;
    int found = 0;
    static char readline[50];
    static struct t_lcp3_info_isdn infisdn;
    fd_set rfds;
    struct timeval tv;
    FILE *adr_book;
    char line[255];
    char templine[255];

    if ( !server->caller_nr_pos ) return;

    FD_ZERO(&rfds);
    FD_SET(0, &rfds);

    // don't wait (argument would be seconds).
    tv.tv_sec =  0;
    tv.tv_usec = 0;

    if ( !select(1, &rfds, NULL, NULL, &tv) ) return;

    readline[0]='\0';

    while ( 1 ) // the loop has a break on EOF
    {
	// what kind of line do we parse right now ?
	while ( 1 ) // go on until you know it!!
	{
	    if( strcmp(readline, server->caller_delimiter) == 0 || position != 0) break;
	    else if( strcmp(readline, server->receiver_delimiter) == 0)
	        return;

/*	    else 
	        scanf("%50s",readline); */
/* changed by sfuchs 20001028, last version: 2.0.5, next: 2.1.0 test 1 */
/* this should fix a isdn_watcher hook-up */
	    else if ( scanf("%50s", readline) == EOF ) return;
	}

        position++;
        if ( scanf("%50s",readline) == EOF ) return;

        if(position == server->month_pos)
	{
	    strncpy(infisdn.month, readline, sizeof(infisdn.month));
	    infisdn.month[sizeof(infisdn.month)-1] = 0;
	}
        else if(position == server->day_pos)
        {
	    strncpy(infisdn.day, readline, sizeof(infisdn.day));
	    infisdn.day[sizeof(infisdn.day)-1] = 0;
        }
        else if(position == server->time_pos)
        {
	    strncpy(infisdn.time, readline, sizeof(infisdn.time));
	    infisdn.time[sizeof(infisdn.time)-1] = 0;
        }
        else if(position == server->caller_nr_pos)
        {
	    strncpy(infisdn.caller, readline, sizeof(infisdn.caller));
	    infisdn.caller[sizeof(infisdn.caller)-1] = 0;
	
	    found = 0;

            if(( adr_book = fopen(server->addressbook_location, "r")) != NULL)
            {
                while( fgets(line, sizeof(line),adr_book) != NULL)
                {
		    if(line[0]== '\n') 
		    {
			if(found ==1)
			    break;

			continue;
		    }
		
		    if(line[0]== '#') // comment lines
		    	continue;

		    // a matching number line, has to start with '@'
		    if(line[0]== '@')
		    {
			if(found == 0)
			{
		    	    if(strstr(line,readline)!=NULL)
				found = 1;
			}
			else
			    return;
		    }
		    else if(found == 1)
		    {
			// check the exact lenght, and cut the rest
			if(strlen(line) > sizeof(infisdn.caller))
			{
			    // addressbook entry too long
			    strncpy(templine,line, sizeof(infisdn.caller));
			    templine[sizeof(infisdn.caller)-1]=0;
			}
			else
			{
			    // addressbook entry shorter then max
			    strncpy(templine,line, strlen(line));
			    templine[strlen(line)-1]=0;	
			}
            		 strncpy(infisdn.caller, templine, sizeof(infisdn.caller));
		    }
                }
            }	
        }
        else if(position == server->receiver_nr_pos)
        {
	    strncpy(infisdn.on, readline, sizeof(infisdn.on));
	    infisdn.on[sizeof(infisdn.on)-1] = 0;
            lcp3_cmd_broadcast(CBR3_ISDNACT, &infisdn, sizeof(struct t_lcp3_info_isdn), NULL);
	    return;
        }
    }
}
