/***************************************************************************
                          parameter.cpp  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "parameter.h"

Parameter::Parameter()
{

Status = UNDEF;

// Defaultsettings

MinimumWindowWidth=640;
MinimumWindowHeight=540;
StatusBarHeight=20;


callsign="";
QslData=0;

serial=-1; // Serial none
SerialDevice="none";
QSOFileName="QSOData.adif";

timeoffset=-2;
clockerror=0;


DemoMode=true;
DemoModeFileType[0]="*.wav";
DemoModeFileType[1]="*.out";
DemoTypeNumber=0;
InputVolume=50;
OutputVolume=50;
slashed0=false;
RxChannels=1;
ActChannel = 0;   // Pointer to the active Channel
ChannelChain = 0; // Pointer to the Start of the Rx - ChannelChain
ApplicationFont =0;

  isInitialized=false;  // Portable Audio not initializde upt to now
}
Parameter::~Parameter()
{
}

void  Parameter::setupDevices()
{
int NumberofDevices;
PaDeviceInfo DeviceInfo;
// Setting up Devicelists
if (! isInitialized )
 return;
InputDevices=0;
NumberofInputDevices=0;
ActualInputDevice=-1;
OutputDevices=0;
ActualOutputDevice=-1;
NumberofOutputDevices=0;
NumberofDevices=Pa_CountDevices();
// Find out possible Devices and count Input and Output Devices
for (int i=0; i<NumberofDevices; i++)
  {
   DeviceInfo = *Pa_GetDeviceInfo( i );
   if (DeviceInfo.maxInputChannels > 0)
    NumberofInputDevices++;
   if (DeviceInfo.maxOutputChannels > 0)
   NumberofOutputDevices++; 
  }
if (NumberofInputDevices >0 )
 InputDevices = new PaDeviceID[NumberofInputDevices];
if ( NumberofOutputDevices >0 )
 OutputDevices = new PaDeviceID[NumberofOutputDevices];
NumberofInputDevices=0;
NumberofOutputDevices=0;
// No sort the devices
for (int i=0; i<NumberofDevices; i++)
  {
   DeviceInfo = *Pa_GetDeviceInfo( i );
   if (DeviceInfo.maxInputChannels > 0)
     InputDevices[NumberofInputDevices++] =i;    
   if (DeviceInfo.maxOutputChannels > 0)
     OutputDevices[NumberofOutputDevices++] =i;    
  }  

}

