/*b
 * Copyright (C) 2001,2002  Rick Richardson
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Rick Richardson <rickr@mn.rr.com>
b*/


typedef void	Sigfunc(int);

#define	SA	struct sockaddr

#if	!defined(__socklen_t_defined) && !defined(socklen_t) && !defined(_SOCKLEN_T)
	#ifdef __APPLE__
	    /* Hack for Darwin OS X */
	    typedef int socklen_t;
	#endif
#	define __socklen_t_defined
#endif

struct hostent *mygethostbyname(const char *name);

Sigfunc *Signal(int signo, Sigfunc *func);

int	connect_timeout(int sockfd, const SA *saptr, socklen_t salen, int secs);

int	read_timeout(int fd, char *buf, int len, int secs);

void	timestamp(FILE *fp);
void	hexdump(FILE *fp, char *lbl1, char *lbln, const void *data, int length);

/*
 * Get N byte value in big endian format
 */
int	getBE(FILE *fp, void *vp, int n);

/*
 * Add a directory to user's $PATH
 */
void add_to_PATH(char *dir);

/*
 * Substitute a string
 */
char *strsub(char *d, int dlen, char *s, char *search, char *replace);

/*
 * Return last character in a string
 */
char strlast(char *s);

/*
 * Split a string
 */
int strsplit(char **strary, int nary, char *str, char sep);

/*
 * Convert date/time strings to unix time
 */
time_t datetime2unix(char *datestr, char *timestr);

/*
 * Given a struct tm, figure out the previous Monday
 */
struct tm *tm2monday(struct tm *today);


/*
 * Hack to peek at stdio buffering
 */
#ifdef _STDIO_USES_IOSTREAM /* defined in libio.h */
	#define FRcnt(f)	( ((f)->_IO_read_end - (f)->_IO_read_ptr) > 0 \
				? (f)->_IO_read_end - (f)->_IO_read_ptr : 0)
#else /* standard stdio */
	#if defined(__CYGWIN__) || defined(__FreeBSD__) || defined(_FSTDIO)
		#define FRcnt(f) ((f)->_r)
	#else
		#define FRcnt(f) ((f)->_cnt)
	#endif
#endif
