package Lire::OutputFormats::XML;

use strict;

use base qw/Lire::OutputFormat/;

use Locale::TextDomain 'lire';

use File::Copy qw/copy/;
eval "use MIME::Entity";

=pod

=head1 NAME

Lire::OutputFormats::XML - XML output format.

=head1 SYNOPSIS

  my $format = Lire::PluginManager->get_plugin( 'output_format', 'xml' );
  $format->format_report( $xml_file, $xml_file );

=head1 DESCRIPTION

Lire::OutputFormat implementation which saves the report as LRML XML.

=cut

sub name {
    return 'xml';
}

sub title {
    return __( 'XML' );
}

sub description {
    return '<para>' . __( 'Native XML format. This keeps the report in Lire Report Markup Language.' ) . '</para>';
}

sub format_report {
    my ( $self, $report_file, $output_file ) = @_;

    copy( $report_file, $output_file );

    return;
}

sub mime_report {
    my ( $self, $report_file, $cfg ) = @_;

    return MIME::Entity->build( 'Type' => 'text/xml',
                                'Charset' => 'utf-8',
                                'Encoding' => 'quoted-printable',
                                'Path' => $report_file
                              );
}

1;

__END__

=pod

=head1 SEE ALSO

 Lire::PluginManager(3pm) Lire::OutputFormat(3pm)

=head1 AUTHOR

Francis J. Lacoste <flacoste@logreport.org>

=head1 VERSION

$Id: XML.pm,v 1.1 2004/08/28 03:41:08 flacoste Exp $

=head1 COPYRIGHT

Copyright (C) 2004 Stichting LogReport Foundation LogReport@LogReport.org

This file is part of Lire.

Lire is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program (see COPYING); if not, check with
http://www.gnu.org/copyleft/gpl.html or write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.

=cut

