## $Id: lr_superservice_po.mk,v 1.3 2004/09/01 18:02:21 flacoste Exp $
##
## Copyright (C) 2000-2004 Stichting LogReport Foundation LogReport@LogReport.org
## 
##     This program is free software; you can redistribute it and/or modify
##     it under the terms of the GNU General Public License as published by
##     the Free Software Foundation; either version 2 of the License, or
##     (at your option) any later version.
## 
##     This program is distributed in the hope that it will be useful,
##     but WITHOUT ANY WARRANTY; without even the implied warranty of
##     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
##     GNU General Public License for more details.
## 
##     You should have received a copy of the GNU General Public License
##     along with this program (see COPYING); if not, check with
##     http://www.gnu.org/copyleft/gpl.html or write to the Free Software 
##     Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111, USA.
##
## These are the common rules for all the superservices po subdirectory
## Makefile.am
##
## The po/Makefile should define the following variables:
## 
## SUPERSERVICE = www
## COPYRIGHT_HOLDER = Stichting LogReport Foundation
## MSGID_BUGS_ADDRESS = bugs@logreport.org
##
## # List of available localization
## LINGUAS = 
## include $(top_srcdir)/include/lr_superservice_po.mk


# you should not modify anything below this line
SCHEMAS = $(wildcard $(srcdir)/../$(SUPERSERVICE).xml)
CFGS = $(wildcard $(srcdir)/../*_default.xml)
REPORTS = $(wildcard $(srcdir)/../reports/*.xml)
FILTERS = $(wildcard $(srcdir)/../filters/*.xml)

SPECS = $(addprefix report_cfg:, $(CFGS)) \
	$(addprefix schema:, $(basename $(notdir $(SCHEMAS)))) \
	$(addprefix report:$(SUPERSERVICE):, $(basename $(notdir $(REPORTS)))) \
	$(addprefix filter:$(SUPERSERVICE):, $(basename $(notdir $(FILTERS))))

POTFILES = $(shell (find $(srcdir)/.. -name '*.pm' -o -name '*.in'  | xargs grep -l 'use Locale::TextDomain' | grep -v Makefile ))

SUFFIXES = .po .mo .pot

TEXTDOMAIN = lire-$(SUPERSERVICE)
XML_POT_SRC = $(TEXTDOMAIN).pot.pl

TEMPLATES = $(TEXTDOMAIN).pot
CATALOGS = $(addsuffix .po, $(LINGUAS))
MO_FILES = $(addsuffix .mo, $(LINGUAS))

LR_SPEC2POT = $(top_builddir)/all/script/lr_spec2pot

SUFFIXES = .po .mo .pot

MAINTAINERCLEANFILES = $(BUILT_SOURCES)

BUILT_SOURCES = $(TEMPLATES) $(MO_FILES) $(XML_POT_SRC)

EXTRA_DIST = $(CATALOGS) $(BUILT_SOURCES)

## Make sure that the first rule is all
all: all-redirect

$(LR_SPEC2POT):
	cd $(top_builddir)/all/script && $(MAKE) $*

$(XML_POT_SRC): $(SCHEMAS) $(FILTERS) $(REPORTS) $(CFGS)
	-rm -f $(srcdir)/../reports/$(SUPERSERVICE) \
	    $(srcdir)/../filters/$(SUPERSERVICE)
	$(LN_S) . $(srcdir)/../reports/$(SUPERSERVICE)
	-test -d $(srcdir)/../filters \
	  && $(LN_S) . $(srcdir)/../filters/$(SUPERSERVICE)
	$(PERL) -w -I$(top_srcdir)/all/lib \
	    $(LR_SPEC2POT) \
	    --cfgspecdir $(top_srcdir)/all/lib/config-spec \
	    --pluginsdir $(top_srcdir)/all/lib/Lire/ChartTypes \
	    --pluginsdir $(top_srcdir)/all/lib/Lire/OutputFormats \
	    --schemasdir $(srcdir)/.. \
	    --reportsdir $(srcdir)/../reports \
	    --filtersdir $(srcdir)/../filters \
	    $(SPECS) \
	  > $(XML_POT_SRC) \
	|| ( rm -f $(XML_POT_SRC) $(srcdir)/../reports/$(SUPERSERVICE) \
	           $(srcdir)/../filters/$(SUPERSERVICE) ; false )
	-rm -f $(srcdir)/../reports/$(SUPERSERVICE) \
	  $(srcdir)/../filters/$(SUPERSERVICE)

$(TEMPLATES): $(POTFILES) $(XML_POT_SRC)
	@echo Updating \'$@\' catalog template.
	$(XGETTEXT) --sort-output  --foreign-user \
		--add-comments=REFERENCE: \
		--copyright-holder="$(COPYRIGHT_HOLDER)" \
		--msgid-bugs-address="$(MSGID_BUGS_ADDRESS)" \
		--keyword='$$__' --keyword=__ --keyword=__x \
		--keyword=__n:1,2 --keyword=__nx:1,2 --keyword=__xn:1,2 \
		--keyword=N__ --language=Perl --output $@ $^

$(CATALOGS): $(TEMPLATES)
	@if test -f $@; then : ; else cp $< $@; fi
	$(MSGMERGE) -U $@ $< && touch $@

.po.mo:
	@echo Generating \'$@\'.
	$(MSGFMT) --check --statistics --verbose -o $@ $<

install-data-local:
	@cd $(srcdir); \
	targetdir='$(DESTDIR)$(LR_PERL5LIBDIR)/LocaleData'; \
	languages='$(LINGUAS)'; \
	for lang in $$languages; do \
		$(mkinstalldirs) "$$targetdir/$$lang/LC_MESSAGES" || exit 1; \
		dest="$$targetdir/$$lang/LC_MESSAGES/$(TEXTDOMAIN).mo"; \
		cat="$$lang.mo"; \
		echo "Installing $$cat as $$dest"; \
		cp -f $$cat $$dest && chmod 644 $$dest || exit 1; \
	done
