/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#ifndef __TREE
#define __TREE

#include "libisofs.h"

struct iso_volumeset;

struct iso_tree_file
{
	/* which volume the file should appear on in the set, usually 0 (1st
	   volume) */
	int volume;

	/* XXX use a libburn_source or iso source? */
	char *path;
	/* full filename extracted from the path, used for calculating the
	   iso/joilet/etc version of the filename */
	char *fullname;
	/* the version of the file (XXX always 1?) */
	int version;

	/* these are derived from the fullname */
	char *name;
	char *extension;

	/* level 1 (8.3) iso name */
	char *isoname1;
	/* level 2 (31) iso name */
	char *isoname2;
	char *jolietname;
	char *rrname;

	/* the logical block at which the file will be placed in the volume */
	int logical_block;
	/* the size of the file */
	int size;

	struct iso_tree_file **me;
	struct iso_volumeset *volset;
};

struct iso_tree_dir
{
	/* which volume the file should appear on in the set, usually 0 (1st
	   volume) */
	int volume;

	char *fullname;

	char *isoname1;
	char *isoname2;
	char *jolietname;
	char *rrname;

	/* the logical block at which the dir will be placed in the volume */
	int logical_block;
	/* the number of bytes needed to hold the directory record for each
	   file and subdirectory of this directory */
	int size;
	/* the position of the directory in the path table */
	short position;

	struct iso_tree_dir *parent;

	struct iso_tree_dir *children;
	int nchildren;
	struct iso_tree_file *files;
	int nfiles;

	struct iso_tree_dir **me;
	struct iso_volumeset *volset;
};

struct iso_tree_dir **iso_tree_new_root(struct iso_volumeset *volset);
void iso_tree_free(struct iso_tree_dir **root);

void iso_tree_sort(struct iso_tree_dir **root);

#endif /* __TREE */
