// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

// Example server demonstrating libcapsi_network.

#include <string>
#include <stdio.h>

// In real applications, use the following includes instead of the local ones.
// #include <libcapsinetwork/listener.h>
// #include <libcapsinetwork/socket.h>
#include "listener.h"
#include "socket.h"

#include "server.h"

int main(int argc, char **argv)
{
	// Create a listener and add a port.
	Listener *listener = new Listener();
	if ( listener->addListenPort(1234) == -1 )
	{
		printf("Could not bind listenPort\n");
		delete listener;
		exit(1);
	}

	// Process events.
	for(;;)
		listener->do_select();

	delete listener;

	return 0;
}

// This is a custom function which must be implemented. It handles activity
// from connected sockets.
void socketHandler(Socket *socket, std::string data)
{
	switch(socket->status())
	{
		case Socket::New:
			socket->setStatus(Socket::Ok); // TODO: move to code that calls handler
			socket->ioWrite(std::string("you are a new connection. welcome.\n"));
			break;
			
		case Socket::Close:
		case Socket::Closed:
			break;
			
		case Socket::Ok:
			printf("[%03d] %s\n", socket->fd(), data.c_str());
			socket->ioWrite(std::string("your input is appreciated.\n"));
			break;
	}
}
