// Copyright (c) 2002 Rob Kaper <cap@capsi.com>
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License version 2.1 as published by the Free Software Foundation.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public License
// along with this library; see the file COPYING.LIB.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.

#ifndef LIBCAPSI_NETWORK_SOCKET_H
#define LIBCAPSI_NETWORK_SOCKET_H

#include <string>

/*
 * Class to handle incoming sockets. Can/will be used to store fd
 * information, etc etc.
 */

class Socket
{
public:
	enum Status { New, Ok, Close, Closed };

	Socket(unsigned int fd);
	void setStatus(Status status) { m_status = status; }
	Status status() { return m_status; }

	int ioWrite(const std::string data);
	const bool hasReadLine();
	const std::string readLine();
	void fillBuffer(const std::string data);

	void setFd(unsigned int _fd) { m_fd = _fd; }
	const unsigned int fd() { return m_fd; }
	void setIpAddr(const std::string ipAddr) { m_ipAddr = ipAddr; m_fqdn = ipAddr; }
	const std::string ipAddr() { return m_ipAddr; }
	void setFqdn(const std::string fqdn) { m_fqdn = fqdn; }
	const std::string fqdn() { return m_fqdn; }

private:
	unsigned int m_fd;
	Status m_status;
	std::string m_ipAddr, m_fqdn, m_ioBuf;
};

#endif // LIBCAPSI_NETWORK_SOCKET_H
