/* GtkDatabox - An extension to the gtk+ library
 * Copyright (C) 1998 - 2002  Dr. Roland Bock
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <stdio.h>

#include <gtk/gtk.h>
#include <gtkdatabox.h>
#include <math.h>
/* Some versions of math.h have a PI problem... */
#ifndef PI
#define PI 3.14159265358979323846
#endif

#define POINTS 50

/*----------------------------------------------------------------
 *  databox show_hide
 *----------------------------------------------------------------*/

static void
do_exit (GtkDatabox *box, GtkWidget *button)
{
  gtk_main_quit ();
}
    
static void
create_show_hide (void)
{
  GtkWidget *window = NULL;
  GtkWidget *box1;
  GtkWidget *box2;
  GtkWidget *close_button;
  GtkWidget *button_box;
  GtkWidget *button;
  GtkWidget *box;
  GtkWidget *label;
  GtkWidget *separator;
  gint index;
  gfloat *X;
  gfloat *Y;
  GdkColor color;
  gint i;
  
    window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    gtk_widget_set_size_request (window, 300, 300);  

    g_signal_connect (GTK_OBJECT (window), "destroy",
			  G_CALLBACK (gtk_main_quit),
			  NULL);

    gtk_window_set_title (GTK_WINDOW (window), "GtkDatabox: Basics");
    gtk_container_set_border_width (GTK_CONTAINER (window), 0);

    box1 = gtk_vbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (window), box1);

    label=gtk_label_new ("Click on the buttons to show/hide\nrulers and scrollbars.\n\nFor basic understanding: See basics :-)");
    gtk_box_pack_start (GTK_BOX (box1), label, FALSE, FALSE, 0);
    separator=gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 0);

    button_box = gtk_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (box1),  button_box, FALSE, FALSE, 0);
    separator=gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, FALSE, 0);
  
    box=gtk_databox_new ();
    
    X=g_new0 (gfloat, POINTS);
    Y=g_new0 (gfloat, POINTS);
    
    for (i = 0; i < POINTS; i++ ) {
      X[i]=i;
      Y[i]=100.*sin (i*2*PI/POINTS);
    }
    color.red=0;
    color.green=0;
    color.blue=65535;
    
    index=gtk_databox_data_add_x_y (GTK_DATABOX (box), POINTS, 
    			X, Y, color, 
    			GTK_DATABOX_BARS, 
    			1);
    
    gtk_databox_rescale (GTK_DATABOX (box));

    gtk_box_pack_start (GTK_BOX (box1), box, TRUE, TRUE, 0);

    separator = gtk_hseparator_new ();
    gtk_box_pack_start (GTK_BOX (box1), separator, FALSE, TRUE, 0);

    box2 = gtk_vbox_new (FALSE, 10);
    gtk_container_set_border_width (GTK_CONTAINER (box2), 10);
    gtk_box_pack_end (GTK_BOX (box1), box2, FALSE, TRUE, 0);
    close_button = gtk_button_new_with_label ("close");
    g_signal_connect_swapped (GTK_OBJECT (close_button), "clicked",
			 G_CALLBACK (do_exit),
			 GTK_OBJECT (box));
    gtk_box_pack_start (GTK_BOX (box2), close_button, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS (close_button, GTK_CAN_DEFAULT);
    /* The show/hide buttons */
    button = gtk_button_new_with_label ("Show Rulers");
    g_signal_connect_swapped (GTK_OBJECT (button), "clicked",
	                         G_CALLBACK (gtk_databox_show_rulers),
				 GTK_OBJECT (box));
    gtk_box_pack_start (GTK_BOX (button_box), button, TRUE, TRUE, 0);
    button = gtk_button_new_with_label ("Hide Rulers");
    g_signal_connect_swapped (GTK_OBJECT (button), "clicked",
	                         G_CALLBACK (gtk_databox_hide_rulers),
				 GTK_OBJECT (box));
    gtk_box_pack_start (GTK_BOX (button_box), button, TRUE, TRUE, 0);
    button = gtk_button_new_with_label ("Show Scrollbars");
    g_signal_connect_swapped (GTK_OBJECT (button), "clicked",
	                         G_CALLBACK (gtk_databox_show_scrollbars),
				 GTK_OBJECT (box));
    gtk_box_pack_start (GTK_BOX (button_box), button, TRUE, TRUE, 0);
    button = gtk_button_new_with_label ("Hide Scrollbars");
    g_signal_connect_swapped (GTK_OBJECT (button), "clicked",
	                         G_CALLBACK (gtk_databox_hide_scrollbars),
				 GTK_OBJECT (box));
    gtk_box_pack_start (GTK_BOX (button_box), button, TRUE, TRUE, 0);
  
    gtk_widget_grab_default (close_button);
  gtk_widget_show_all (window);

}

gint 
main (gint argc, char *argv[])
{
  gtk_init (&argc, &argv);
  
  create_show_hide ();
  gtk_main ();

  return 0;
}
