#include "helloworld.h"
#include <inti/gtk/button.h>
#include <iostream>

HelloWorld::HelloWorld()
{
	// Sets the border width of the window. 
	set_border_width(10);

	// Creates a new button with the label "Hello World".
	Gtk::Button *button = new Gtk::Button("Hello World");

	// When the button receives the "clicked" signal, it calls the on_hello() slot.
	button->sig_clicked().connect(slot(this, &HelloWorld::on_hello));

	// This will cause the window to be destroyed by calling HelloWindow's inherited dispose method.
	button->sig_clicked().connect(slot(this, &HelloWorld::dispose));

	// This packs the button into the window (a Gtk::Container).
	add(*button);

	// The final step is to display this newly created widget.
	button->show();
}

HelloWorld::~HelloWorld()
{
}

bool
HelloWorld::on_delete_event(const Gdk::EventAny& event)
{
	// When the window is given the "delete_event" signal (this is given by the window manager,
	// usually by the "close" option, or on the titlebar), the on_delete_event() slot is called.
	// If you return false a "destroy" signal is emitted. Returning true means you don't want
	// the window to be destroyed. This is useful for popping up 'are you sure you want to quit?'
	// type dialogs.
	std::cout << "delete event occurred" << '\n';
	return true;
}

void
HelloWorld::on_hello()
{
	std::cout << "Hello World" << std::endl;
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	HelloWorld window;
	window.sig_destroy().connect(slot(&Inti::Main::quit));
	window.show();

	run();
	return 0;
}

