#include "radiobuttons.h"
#include <inti/gtk/radiobutton.h>
#include <inti/gtk/separator.h>

RadioButtonWindow::RadioButtonWindow()
{
	set_title("radio buttons");
	set_border_width(0);

	Gtk::VBox *box1 = new Gtk::VBox;
	add(*box1);
	box1->show();

	Gtk::VBox *box2 = new Gtk::VBox(false, 10);
	box2->set_border_width(10);
	box1->pack_start(*box2);
	box2->show();

	// When adding the first radio button to a group pass null for the group paramter.
	Gtk::RadioButton::Group *group = 0;
	Gtk::RadioButton *radio_button = new Gtk::RadioButton(group, "button1");
	box2->pack_start(*radio_button);
	radio_button->show();

	// Then, pass the group returned by calling get_group() to the constructors of the other buttons.
	group = radio_button->get_group();
	radio_button = new Gtk::RadioButton(group, "button2");
	radio_button->set_active(true);
	box2->pack_start(*radio_button);
	radio_button->show();

	// Or even easier, pass a pointer to a radio button already in the group.
	radio_button = new Gtk::RadioButton(radio_button, "button3");
	box2->pack_start(*radio_button);
	radio_button->show();

	Gtk::HSeparator *separator = new Gtk::HSeparator;
	box1->pack_start(*separator, false);
	separator->show();

	box2 = new Gtk::VBox(false, 10);
	box2->set_border_width(10);
	box1->pack_start(*box2, false);
	box2->show();

	Gtk::Button *button = new Gtk::Button("close");
	button->sig_clicked().connect(slot(this, &RadioButtonWindow::dispose));
	box2->pack_start(*button);
	button->set_flags(Gtk::CAN_DEFAULT);
	button->grab_default();
	button->show();
}

RadioButtonWindow::~RadioButtonWindow()
{
}

int main (int argc, char *argv[])
{
	using namespace Main;

	init(&argc, &argv);

	RadioButtonWindow window;
	window.sig_destroy().connect(slot(&Inti::Main::quit));
	window.show();

	run();
	return 0;
}

