/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  action.cc - AtkAction C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "action.h"
#include "private/action_p.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::Action
 */

Atk::Action::~Action()
{
}
	
AtkActionIface* 
Atk::Action::atk_action_iface() const 
{ 
	return peek<AtkActionIface>(ATK_TYPE_ACTION); 
}

Atk::Action::operator AtkAction* () const 
{ 
	return this ? atk_action() : 0; 
}
	
int 
Atk::Action::get_n_actions() const
{
	return atk_action_get_n_actions(atk_action());
}

String
Atk::Action::get_description(int i) const
{
	return atk_action_get_description(atk_action(), i);
}

String
Atk::Action::get_name(int i) const
{
	return atk_action_get_name(atk_action(), i);
}

String
Atk::Action::get_keybinding(int i) const
{
	return atk_action_get_keybinding(atk_action(), i);
}

String 
Atk::Action::get_localized_name(int i) const
{
	return atk_action_get_localized_name(atk_action(), i);
}

bool
Atk::Action::do_action(int i)
{
	return atk_action_do_action(atk_action(), i);
}

bool
Atk::Action::set_description(int i, const char *desc)
{
	return atk_action_set_description(atk_action(), i, desc);
}

/*  Atk::ActionIface
 */

void
Atk::ActionIface::init(AtkActionIface *g_iface)
{
	g_iface->do_action = &do_action_proxy;
	g_iface->get_n_actions = &get_n_actions_proxy;
	g_iface->get_description = &get_description_proxy;
	g_iface->get_name = &get_name_proxy;
	g_iface->get_keybinding = &get_keybinding_proxy;
	g_iface->set_description = &set_description_proxy;
	g_iface->get_localized_name = &get_localized_name_proxy;
}

gboolean
Atk::ActionIface::do_action_proxy(AtkAction *action, gint i)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_do_action(i);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->do_action)
			result = g_iface->do_action(action, i);
	}
	return result;
}

gint
Atk::ActionIface::get_n_actions_proxy(AtkAction *action)
{
	gint result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_get_n_actions();
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->get_n_actions)
			result = g_iface->get_n_actions(action);
	}
	return result;
}


const gchar*
Atk::ActionIface::get_description_proxy(AtkAction *action, gint i)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_get_description(i);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->get_description)
			result = g_iface->get_description(action, i);
	}
	return result;
}

const gchar*
Atk::ActionIface::get_name_proxy(AtkAction *action, gint i)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_get_name(i);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->get_name)
			result = g_iface->get_name(action, i);
	}
	return result;
}

const gchar*
Atk::ActionIface::get_keybinding_proxy(AtkAction *action, gint i)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_get_keybinding(i);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->get_keybinding)
			result = g_iface->get_keybinding(action, i);
	}
	return result;
}

gboolean
Atk::ActionIface::set_description_proxy(AtkAction *action, gint i, const gchar *desc)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_set_description(i, desc);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->set_description)
			result = g_iface->set_description(action, i, desc);
	}
	return result;
}

const gchar*
Atk::ActionIface::get_localized_name_proxy(AtkAction *action, gint i)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(action));
	Atk::Action *tmp_action = dynamic_cast<Atk::Action*>(object);
	if (tmp_action)
		result = tmp_action->do_get_localized_name(i);
	else
	{
		AtkActionIface *g_iface = static_cast<AtkActionIface*>(g_type_interface_peek_parent(ATK_ACTION_GET_IFACE(action)));
		if (g_iface->get_localized_name)
			result = g_iface->get_localized_name(action, i);
	}
	return result;
}

/*  Overridable methods
 */

bool
Atk::Action::do_do_action(int i)
{
	bool result = false;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->do_action)
		result = g_iface->do_action(atk_action(), i);
	return result;
}

int
Atk::Action::do_get_n_actions()
{
	int result = 0;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->get_n_actions)
		result = g_iface->get_n_actions(atk_action());
	return result;
}

const char*
Atk::Action::do_get_description(int i)
{
	const char *result = 0;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->get_description)
		result = g_iface->get_description(atk_action(), i);
	return result;
}

const char*
Atk::Action::do_get_name(int i)
{
	const char *result = 0;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->get_name)
		result = g_iface->get_name(atk_action(), i);
	return result;
}

const char*
Atk::Action::do_get_keybinding(int i)
{
	const char *result = 0;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->get_keybinding)
		result = g_iface->get_keybinding(atk_action(), i);
	return result;
}

bool
Atk::Action::do_set_description(int i, const char *desc)
{
	bool result = false;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->set_description)
		result = g_iface->set_description(atk_action(), i, desc);
	return result;
}

const char*
Atk::Action::do_get_localized_name(int i)
{
	const char *result = 0;
	AtkActionIface *g_iface = peek_parent<AtkActionIface>(atk_action_iface());
	if (g_iface->get_localized_name)
		result = g_iface->get_localized_name(atk_action(), i);
	return result;
}

