/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  image.cc - AtkImage C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "image.h"
#include "private/image_p.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::Image
 */

Atk::Image::~Image()
{
}
	
AtkImageIface* 
Atk::Image::atk_image_iface() const 
{ 
	return peek<AtkImageIface>(ATK_TYPE_IMAGE); 
}
	
Atk::Image::operator AtkImage* () const 
{ 
	return this ? atk_image() : 0; 
}
	
String
Atk::Image::get_image_description() const
{
	return atk_image_get_image_description(atk_image());
}

void
Atk::Image::get_image_size(int *height, int *width) const
{
	atk_image_get_image_size(atk_image(), height, width);
}

void 
Atk::Image::get_image_position(int *x, int *y, CoordType coord_type) const
{
	atk_image_get_image_position(atk_image(), x, y, (AtkCoordType)coord_type);
}

bool 
Atk::Image::set_image_description(const String& description)
{
	return atk_image_set_image_description(atk_image(), description.c_str());
}

/*  Atk::ImageIface
 */

void
Atk::ImageIface::init(AtkImageIface *g_iface)
{
	g_iface->get_image_position = &get_image_position_proxy;
	g_iface->get_image_description = &get_image_description_proxy;
	g_iface->get_image_size = &get_image_size_proxy;
	g_iface->set_image_description = &set_image_description_proxy;
}

void
Atk::ImageIface::get_image_position_proxy(AtkImage *image, gint *x, gint *y, AtkCoordType coord_type)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(image));
	Atk::Image *tmp_image = dynamic_cast<Atk::Image*>(object);
	if (tmp_image)
		tmp_image->do_get_image_position(x, y, coord_type);
	else
	{
		AtkImageIface *g_iface = static_cast<AtkImageIface*>(g_type_interface_peek_parent(ATK_IMAGE_GET_IFACE(image)));
		if (g_iface->get_image_position)
			g_iface->get_image_position(image, x, y, coord_type);
	}
}

const gchar*
Atk::ImageIface::get_image_description_proxy(AtkImage *image)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(image));
	Atk::Image *tmp_image = dynamic_cast<Atk::Image*>(object);
	if (tmp_image)
		result = tmp_image->do_get_image_description();
	else
	{
		AtkImageIface *g_iface = static_cast<AtkImageIface*>(g_type_interface_peek_parent(ATK_IMAGE_GET_IFACE(image)));
		if (g_iface->get_image_description)
			result = g_iface->get_image_description(image);
	}
	return result;
}

void
Atk::ImageIface::get_image_size_proxy(AtkImage *image, gint *width, gint *height)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(image));
	Atk::Image *tmp_image = dynamic_cast<Atk::Image*>(object);
	if (tmp_image)
		tmp_image->do_get_image_size(width, height);
	else
	{
		AtkImageIface *g_iface = static_cast<AtkImageIface*>(g_type_interface_peek_parent(ATK_IMAGE_GET_IFACE(image)));
		if (g_iface->get_image_size)
			g_iface->get_image_size(image, width, height);
	}
}

gboolean
Atk::ImageIface::set_image_description_proxy(AtkImage *image, const gchar *description)
{
	gboolean result = FALSE;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(image));
	Atk::Image *tmp_image = dynamic_cast<Atk::Image*>(object);
	if (tmp_image)
		result = tmp_image->do_set_image_description(description);
	else
	{
		AtkImageIface *g_iface = static_cast<AtkImageIface*>(g_type_interface_peek_parent(ATK_IMAGE_GET_IFACE(image)));
		if (g_iface->set_image_description)
			result = g_iface->set_image_description(image, description);
	}
	return result;
}

/*  Overridable methods
 */

void
Atk::Image::do_get_image_position(int *x, int *y, AtkCoordType coord_type)
{
	AtkImageIface *g_iface = peek_parent<AtkImageIface>(atk_image_iface());
	if (g_iface->get_image_position)
		g_iface->get_image_position(atk_image(), x, y, coord_type);
}

const char*
Atk::Image::do_get_image_description()
{
	const char *result = 0;
	AtkImageIface *g_iface = peek_parent<AtkImageIface>(atk_image_iface());
	if (g_iface->get_image_description)
		result = g_iface->get_image_description(atk_image());
	return result;
}

void
Atk::Image::do_get_image_size(int *width, int *height)
{
	AtkImageIface *g_iface = peek_parent<AtkImageIface>(atk_image_iface());
	if (g_iface->get_image_size)
		g_iface->get_image_size(atk_image(), width, height);
}

bool
Atk::Image::do_set_image_description(const char *description)
{
	bool result = false;
	AtkImageIface *g_iface = peek_parent<AtkImageIface>(atk_image_iface());
	if (g_iface->set_image_description)
		result = g_iface->set_image_description(atk_image(), description);
	return result;
}

