/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  objectfactory.cc - AtkObjectFactory C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "objectfactory.h"
#include "private/objectfactory_p.h"
#include "object.h"

using namespace Inti;

/*  Atk::ObjectFactory
 */

Atk::ObjectFactory::ObjectFactory(AtkObjectFactory *factory, bool reference)
: G::Object((GObject*)factory, reference)
{
}
	
Atk::ObjectFactory::~ObjectFactory() 
{
}
	
AtkObjectFactoryClass* 
Atk::ObjectFactory::atk_object_factory_class() const 
{ 
	return get_class<AtkObjectFactoryClass>(); 
}

Atk::ObjectFactory::operator AtkObjectFactory* () const 
{ 
	return this ? atk_object_factory() : 0; 
}
	
GType
Atk::ObjectFactory::get_accessible_type() const
{
	return atk_object_factory_get_accessible_type(atk_object_factory());
}

Atk::Object*
Atk::ObjectFactory::create_accessible(const G::Object& object)
{
	return G::Object::wrap<Atk::Object>(atk_object_factory_create_accessible(atk_object_factory(), object.g_object()));
}

void 
Atk::ObjectFactory::invalidate()
{   
	atk_object_factory_invalidate(atk_object_factory()); 
}

/*  Atk::ObjectFactoryClass
 */

void
Atk::ObjectFactoryClass::init(AtkObjectFactoryClass *g_class)
{
	G::ObjectClass::init((GObjectClass*)g_class);
	g_class->invalidate = &invalidate_proxy;
}

GType
Atk::ObjectFactoryClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(ATK_TYPE_OBJECT_FACTORY, (GClassInitFunc)init);
	}
	return type;
}

void*
Atk::ObjectFactoryClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Atk::ObjectFactoryClass::invalidate_proxy(AtkObjectFactory *factory)
{
	Atk::ObjectFactory *tmp_factory = G::Object::pointer<Atk::ObjectFactory>(factory);
	if (tmp_factory)
		tmp_factory->do_invalidate();
	else
	{
		AtkObjectFactoryClass *tmp_class = ATK_OBJECT_FACTORY_GET_CLASS(factory);
		AtkObjectFactoryClass *g_class = G::TypeInstance::class_peek_parent<AtkObjectFactoryClass>(tmp_class);
		if (g_class->invalidate)
			g_class->invalidate(factory);
	}
}

// Overridable methods

void
Atk::ObjectFactory::do_invalidate()
{
	AtkObjectFactoryClass *g_class = class_peek_parent<AtkObjectFactoryClass>(atk_object_factory_class());
	if (g_class->invalidate)
		g_class->invalidate(atk_object_factory());
}

