/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  editabletext_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_EDITABLE_TEXT_IFACE_H
#define INTI_ATK_EDITABLE_TEXT_IFACE_H

namespace Inti {

namespace Atk {

class EditableTextIface
{
public:
	static void init(AtkEditableTextIface *g_iface);

	static gboolean set_run_attributes_proxy(AtkEditableText *text, AtkAttributeSet *attrib_set, gint start_offset, gint end_offset);

	static void set_text_contents_proxy(AtkEditableText *text, const gchar *string);

	static void insert_text_proxy(AtkEditableText *text, const gchar *string, gint length, gint *position);

	static void copy_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos);

	static void cut_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos);

	static void delete_text_proxy(AtkEditableText *text, gint start_pos, gint end_pos);

	static void paste_text_proxy(AtkEditableText *text, gint position);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_EDITABLE_TEXT_IFACE_H
