/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  streamablecontent_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_ATK_STREAMABLE_CONTENT_IFACE_H
#define INTI_ATK_STREAMABLE_CONTENT_IFACE_H

namespace Inti {

namespace Atk {

class StreamableContentIface
{
public:
	static void init(AtkStreamableContentIface *g_iface);

	static gint get_n_mime_types_proxy(AtkStreamableContent *streamable);

	static const gchar* get_mime_type_proxy(AtkStreamableContent *streamable, gint i);

	static GIOChannel* get_stream_proxy(AtkStreamableContent *streamable, const gchar *mime_type);
};

} // namespace Atk

} // namespace Inti

#endif // INTI_ATK_STREAMABLE_CONTENT_IFACE_H
