/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  streamablecontent.cc - AtkStreamableContent C++ wrapper interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "streamablecontent.h"
#include "private/streamablecontent_p.h"
#include "../glib/object.h"

using namespace Inti;

/*  Atk::StreamableContent
 */

Atk::StreamableContent::~StreamableContent()
{
}
	
AtkStreamableContentIface* 
Atk::StreamableContent::atk_streamable_content_iface() const 
{ 
	return peek<AtkStreamableContentIface>(ATK_TYPE_STREAMABLE_CONTENT); 
}
	
Atk::StreamableContent::operator AtkStreamableContent* () const 
{
	return this ? atk_streamable_content() : 0; 
}
	
int 
Atk::StreamableContent::get_n_mime_types() const
{
	return atk_streamable_content_get_n_mime_types(atk_streamable_content());
}

String
Atk::StreamableContent::get_mime_type(int i) const
{
	return atk_streamable_content_get_mime_type(atk_streamable_content(), i);
}

GIOChannel* 
Atk::StreamableContent::get_stream(const String& mime_type) const
{
	return atk_streamable_content_get_stream(atk_streamable_content(), mime_type.c_str());
}

/*  Atk::StreamableContentIface
 */

void
Atk::StreamableContentIface::init(AtkStreamableContentIface *g_iface)
{
	g_iface->get_n_mime_types = &get_n_mime_types_proxy;
	g_iface->get_mime_type = &get_mime_type_proxy;
	g_iface->get_stream = &get_stream_proxy;
}

gint
Atk::StreamableContentIface::get_n_mime_types_proxy(AtkStreamableContent *streamable)
{
	gint result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(streamable));
	Atk::StreamableContent *tmp_streamable = dynamic_cast<Atk::StreamableContent*>(object);
	if (tmp_streamable)
		result = tmp_streamable->do_get_n_mime_types();
	else
	{
		AtkStreamableContentIface *tmp_iface = ATK_STREAMABLE_CONTENT_GET_IFACE(streamable);
		AtkStreamableContentIface *g_iface = static_cast<AtkStreamableContentIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->get_n_mime_types)
			result = g_iface->get_n_mime_types(streamable);
	}
	return result;
}

const gchar*
Atk::StreamableContentIface::get_mime_type_proxy(AtkStreamableContent *streamable, gint i)
{
	const gchar *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(streamable));
	Atk::StreamableContent *tmp_streamable = dynamic_cast<Atk::StreamableContent*>(object);
	if (tmp_streamable)
		result = tmp_streamable->do_get_mime_type(i);
	else
	{
		AtkStreamableContentIface *tmp_iface = ATK_STREAMABLE_CONTENT_GET_IFACE(streamable);
		AtkStreamableContentIface *g_iface = static_cast<AtkStreamableContentIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->get_mime_type)
			result = g_iface->get_mime_type(streamable, i);
	}
	return result;
}

GIOChannel*
Atk::StreamableContentIface::get_stream_proxy(AtkStreamableContent *streamable, const gchar *mime_type)
{
	GIOChannel *result = 0;
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(streamable));
	Atk::StreamableContent *tmp_streamable = dynamic_cast<Atk::StreamableContent*>(object);
	if (tmp_streamable)
		result = tmp_streamable->do_get_stream(mime_type);
	else
	{
		AtkStreamableContentIface *tmp_iface = ATK_STREAMABLE_CONTENT_GET_IFACE(streamable);
		AtkStreamableContentIface *g_iface = static_cast<AtkStreamableContentIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->get_stream)
			result = g_iface->get_stream(streamable, mime_type);
	}
	return result;
}

/*  Overridable methods
 */

int
Atk::StreamableContent::do_get_n_mime_types()
{
	int result = 0;
	AtkStreamableContentIface *g_iface = peek_parent<AtkStreamableContentIface>(atk_streamable_content_iface());
	if (g_iface->get_n_mime_types)
		result = g_iface->get_n_mime_types(atk_streamable_content());
	return result;
}

const char*
Atk::StreamableContent::do_get_mime_type(int i)
{
	const char *result = 0;
	AtkStreamableContentIface *g_iface = peek_parent<AtkStreamableContentIface>(atk_streamable_content_iface());
	if (g_iface->get_mime_type)
		result = g_iface->get_mime_type(atk_streamable_content(), i);
	return result;
}


GIOChannel*
Atk::StreamableContent::do_get_stream(const char *mime_type)
{
	GIOChannel *result = 0;
	AtkStreamableContentIface *g_iface = peek_parent<AtkStreamableContentIface>(atk_streamable_content_iface());
	if (g_iface->get_stream)
		result = g_iface->get_stream(atk_streamable_content(), mime_type);
	return result;
}

