/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *  Copyright (C) 2000 Red Hat, Inc.
 *
 *  connection.cc - C++ signal-slot connection implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "connection.h"
#include "slot.h"

using namespace Inti;

/*  Node
 */
	
Node::Node(Slot *slot)
: slot_(slot)
{
}
 	
Node::~Node()
{
	slot_->unref();
}

/*  Connection
 */

Connection::Connection()
: node_(0)
{
}
	
Connection::Connection(Node *node)
: node_(node)
{
	node_->ref();
}

Connection::Connection(const Connection& src)
: node_(src.node_)
{
	if (node_)
		node_->ref();
}

Connection::~Connection()
{
	if (node_)
		node_->unref();
}
	
Connection&
Connection::operator=(const Connection& src)
{
	if (src.node_ == node_)
		return *this;

	if (src.node_)
		src.node_->ref();

	if (node_)
		node_->unref();

	node_ = src.node_;
	return *this;
}

bool
Connection::is_connected() const
{
	return node_ != 0;
}

void
Connection::block()
{
	if (node_)
		node_->block();
}

void 
Connection::unblock()
{
	if (node_)
		node_->unblock();
}
		
void
Connection::disconnect()
{
	if (node_)
	{
		node_->disconnect();
		node_->unref();
		node_ = 0;
	}
}

