/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *  Copyright (C) 2000 Red Hat, Inc.
 *
 *  signals.cc - C++ GTK+ signal implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "type.h"
#include <glib-object.h>

using namespace Inti;

/*  G::SlotNode
 */
 
G::SlotNode::SlotNode(GObject *object, const Slot *slot)
: Node(const_cast<Slot*>(slot)), object_(object), connect_id(0)
{
}
	
G::SlotNode::~SlotNode()
{
	if (object_)
		disconnect();
}

void 
G::SlotNode::destroy(void *data)
{
 	SlotNode *node = static_cast<SlotNode*>(data);
	node->object_ = 0;
	node->unref();
}

G::SlotNode*
G::SlotNode::connect(TypeInstance *instance, const char *name, GCallback callback, const Slot *slot, bool after)
{
	g_return_val_if_fail(instance != 0, 0);
	g_return_val_if_fail(slot != 0, 0);
	SlotNode *node = new SlotNode((GObject*)instance->g_type_instance(), slot);
	GClosure* closure = g_cclosure_new_swap(callback, node, (GClosureNotify)&SlotNode::destroy);
	node->connect_id = g_signal_connect_closure(node->object_, name, closure, after);
	return node;
}

void
G::SlotNode::block()
{
	if (object_ && object_->ref_count > 0)
		g_signal_handler_block(object_, connect_id);
}
			
void 
G::SlotNode::unblock()
{
	if (object_ && object_->ref_count > 0)
		g_signal_handler_unblock(object_, connect_id);
}
	
void
G::SlotNode::disconnect()
{ 
	GObject *tmp = object_;
	object_ = 0;
	if (tmp && tmp->ref_count > 0)
	{
		g_signal_handler_disconnect(tmp, connect_id);
		connect_id = 0;
	}
}

/*  G::Signal
 */
 
G::Signal::Signal(const char *name)
: name_(name)
{
}

G::Signal::~Signal()
{
}

G::SlotNode*
G::Signal::connect(TypeInstance *instance, GCallback callback, const Slot *slot, bool after) const
{
	return SlotNode::connect(instance, name_, callback, slot, after);
}

const char*
G::Signal::name() const
{
	return name_; 
}

