/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  accessible.cc - GtkAccessible C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtkwidget.h>
#include "accessible.h"
#include "private/accessible_p.h"

using namespace Inti;

/*  Gtk::Accessible
 */

Gtk::Accessible::Accessible(GtkAccessible *accessible, bool reference)
: Atk::Object((AtkObject*)accessible, reference)
{
}

Gtk::Accessible::~Accessible()
{
}

GtkAccessibleClass*
Gtk::Accessible::gtk_accessible_class() const
{
	return get_class<GtkAccessibleClass>();
}

Gtk::Accessible::operator GtkAccessible* () const
{
	return this ? gtk_accessible() : 0;
}

void
Gtk::Accessible::connect_widget_destroyed()
{
	gtk_accessible_connect_widget_destroyed(gtk_accessible());
}

/*  Gtk::AccessibleClass
 */

void
Gtk::AccessibleClass::init(GtkAccessibleClass *g_class)
{
	Atk::ObjectClass::init((AtkObjectClass*)g_class);
	g_class->connect_widget_destroyed = &connect_widget_destroyed_proxy;
}

GType
Gtk::AccessibleClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_ACCESSIBLE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::AccessibleClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::AccessibleClass::connect_widget_destroyed_proxy(GtkAccessible *accessible)
{
	Accessible *tmp_accessible = G::Object::pointer<Accessible>(accessible);
	if (tmp_accessible)
		tmp_accessible->do_connect_widget_destroyed();
	else
	{
		GtkAccessibleClass *g_class = G::TypeInstance::class_peek_parent<GtkAccessibleClass>(GTK_ACCESSIBLE_GET_CLASS(accessible));
		if (g_class->connect_widget_destroyed)
			g_class->connect_widget_destroyed(accessible);
	}
}

/*  Overridable GtkAccessible methods
 */

void
Gtk::Accessible::do_connect_widget_destroyed()
{
	GtkAccessibleClass *g_class = class_peek_parent<GtkAccessibleClass>(gtk_accessible_class());
	if (g_class->connect_widget_destroyed)
		g_class->connect_widget_destroyed(gtk_accessible());
}

