/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  curve.cc - GtkCurve C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "curve.h"
#include "private/curve_p.h"

using namespace Inti;

/*  Gtk::Curve
 */

Gtk::Curve::Curve(GtkCurve *curve, bool reference)
: DrawingArea((GtkDrawingArea*)curve, reference)
{
}
	
Gtk::Curve::Curve()
: DrawingArea((GtkDrawingArea*)CurveClass::create())
{
}

Gtk::Curve::~Curve() 
{
}
	
GtkCurveClass*
Gtk::Curve::gtk_curve_class() const
{
	return get_class<GtkCurveClass>();
}
	
Gtk::Curve::operator GtkCurve* () const
{ 
	return this ? gtk_curve() : 0;
}
	
void
Gtk::Curve::get_vector(int count, float data[]) const
{
	gtk_curve_get_vector(gtk_curve(), count, data);
}

void
Gtk::Curve::reset()
{
	gtk_curve_reset(gtk_curve());
}

void
Gtk::Curve::set_gamma(float gamma)
{
	gtk_curve_set_gamma(gtk_curve(), gamma);
}

void
Gtk::Curve::set_range(float min_x, float max_x, float min_y, float max_y)
{
	gtk_curve_set_range(gtk_curve(), min_x, max_x, min_y, max_y);
}

void
Gtk::Curve::set_vector(int count, float data[])
{
	gtk_curve_set_vector(gtk_curve(), count, data);
}

void 
Gtk::Curve::set_curve_type(CurveType type)
{
	gtk_curve_set_curve_type(gtk_curve(), (GtkCurveType)type);
}

/*  Gtk::CurveClass
 */

void
Gtk::CurveClass::init(GtkCurveClass *g_class)
{
	DrawingAreaClass::init((GtkDrawingAreaClass*)g_class);
	g_class->curve_type_changed = &curve_type_changed_proxy;
}

GType
Gtk::CurveClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_CURVE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::CurveClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::CurveClass::curve_type_changed_proxy(GtkCurve *curve)
{
	Curve *tmp_curve = G::Object::pointer<Curve>(curve);
	if (tmp_curve)
		tmp_curve->on_curve_type_changed();
	else
	{
		GtkCurveClass *g_class = G::TypeInstance::class_peek_parent<GtkCurveClass>(GTK_CURVE_GET_CLASS(curve));
		if (g_class->curve_type_changed)
			g_class->curve_type_changed(curve);
	}
}

/*  Signal handlers
 */

void
Gtk::Curve::on_curve_type_changed()
{
	GtkCurveClass *g_class = class_peek_parent<GtkCurveClass>(gtk_curve_class());
	if (g_class->curve_type_changed)
		g_class->curve_type_changed(gtk_curve());
}

/*  Properties
 */

const Gtk::Curve::CurveTypePropertyType Gtk::Curve::curve_type_property("curve_type");

const Gtk::Curve::MinXPropertyType Gtk::Curve::min_x_property("min_x");

const Gtk::Curve::MinYPropertyType Gtk::Curve::min_y_property("min_y");

const Gtk::Curve::MaxXPropertyType Gtk::Curve::max_x_property("max_x");

const Gtk::Curve::MaxYPropertyType Gtk::Curve::max_y_property("max_y");

/*  Signals
 */

const Gtk::Curve::CurveTypeChangedSignalType Gtk::Curve::curve_type_changed_signal("curve_type_changed");

