/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002 The Inti Development Team.
 *
 *  dnd.cc - Gtk Drag and Drop wrapper component implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "dnd.h"
#include "widget.h"
#include "../gdk/bitmap.h"
#include "../gdk/color.h"
#include "../gdk/pixmap.h"
#include "../gdk-pixbuf/pixbuf.h"

using namespace Inti;

Gtk::DragContext::DragContext(GdkDragContext *drag_context, bool reference)
: Gdk::DragContext(drag_context, reference)
{
}
	
Gtk::DragContext::~DragContext()
{
}

Gtk::Widget* 
Gtk::DragContext::get_source_widget() const
{
	return G::Object::wrap<Widget>(gtk_drag_get_source_widget(gdk_drag_context()));
}

void 
Gtk::DragContext::finish(bool success, bool delete_data, unsigned int time)
{
	gtk_drag_finish(gdk_drag_context(), success, delete_data, time);
}

void 
Gtk::DragContext::set_icon_widget(Widget& widget, int hot_x, int hot_y)
{
	gtk_drag_set_icon_widget(gdk_drag_context(), widget.gtk_widget(), hot_x, hot_y);
}

void 
Gtk::DragContext::set_icon_pixmap(Gdk::Colormap& colormap, Gdk::Pixmap& pixmap, Gdk::Bitmap *mask, int hot_x, int hot_y)
{
	gtk_drag_set_icon_pixmap(gdk_drag_context(), colormap.gdk_colormap(), pixmap.gdk_pixmap(), *mask, hot_x, hot_y);
}

void 
Gtk::DragContext::set_icon_pixbuf(Gdk::Pixbuf& pixbuf, int hot_x, int hot_y)
{
	gtk_drag_set_icon_pixbuf(gdk_drag_context(), pixbuf.gdk_pixbuf(), hot_x, hot_y);
}

void 
Gtk::DragContext::set_icon_stock(const char *stock_id, int hot_x, int hot_y)
{
	gtk_drag_set_icon_stock(gdk_drag_context(), stock_id, hot_x, hot_y);
}

void 
Gtk::DragContext::set_icon_default()
{
	gtk_drag_set_icon_default(gdk_drag_context());
}

