/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  gammacurve.cc - GtkGammaCurve C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "gammacurve.h"
#include "private/gammacurve_p.h"

using namespace Inti;

/*  Gtk::GammaCurve
 */

Gtk::GammaCurve::GammaCurve(GtkGammaCurve *gamma_curve, bool reference)
: VBox((GtkVBox*)gamma_curve, reference)
{
}
	
Gtk::GammaCurve::GammaCurve()
: VBox((GtkVBox*)GammaCurveClass::create())
{
}

Gtk::GammaCurve::~GammaCurve() 
{
}
	
GtkGammaCurveClass* 
Gtk::GammaCurve::gtk_gamma_curve_class() const
{
	return get_class<GtkGammaCurveClass>();
}
	
Gtk::GammaCurve::operator GtkGammaCurve* () const
{ 
	return this ? gtk_gamma_curve() : 0; 
}
	
/*  Gtk::GammaCurveClass
 */

void
Gtk::GammaCurveClass::init(GtkGammaCurveClass *g_class)
{
	VBoxClass::init((GtkVBoxClass*)g_class);
}

GType
Gtk::GammaCurveClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_GAMMA_CURVE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::GammaCurveClass::create()
{
	return g_object_new(get_type(), 0);
}

