/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  container_p.h - Private interface
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef INTI_GTK_CONTAINER_CLASS_H
#define INTI_GTK_CONTAINER_CLASS_H

#include <inti/gtk/private/widget_p.h>

namespace Inti {

namespace Gtk {

class ContainerClass
{
public:
	static void init(GtkContainerClass *g_class);

	static GType get_type();

	static void* create();

// Methods
	static void forall_proxy(GtkContainer *container, gboolean include_internals, GtkCallback callback, gpointer callback_data);

	static GtkType child_type_proxy(GtkContainer *container);

	static gchar* composite_name_proxy(GtkContainer	*container, GtkWidget *child);

	static void set_child_property_proxy(GtkContainer *container, GtkWidget *child, guint property_id, const GValue *value, GParamSpec *pspec);

	static void get_child_property_proxy(GtkContainer *container, GtkWidget *child, guint property_id, GValue *value, GParamSpec *pspec);

// Signals
	static void add_proxy(GtkContainer *container, GtkWidget *widget);

	static void remove_proxy(GtkContainer *container, GtkWidget *widget);

	static void check_resize_proxy(GtkContainer *container);

	static void set_focus_child_proxy(GtkContainer *container, GtkWidget *widget);
};

} // namespace Gtk

} // namespace Inti

#endif // INTI_GTK_CONTAINER_CLASS_H
