/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  progressbar.cc - GtkProgressBar C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "progressbar.h"
#include "private/progressbar_p.h"

using namespace Inti;

/*  Gtk::ProgressBar
 */

Gtk::ProgressBar::ProgressBar(GtkProgressBar *progress_bar, bool reference)
: Widget((GtkWidget*)progress_bar, reference)
{
}

Gtk::ProgressBar::ProgressBar()
: Widget((GtkWidget*)ProgressBarClass::create())
{
}

Gtk::ProgressBar::ProgressBar(ProgressBarOrientation orientation)
: Widget((GtkWidget*)ProgressBarClass::create())
{
	set_orientation(orientation);
}

Gtk::ProgressBar::~ProgressBar()
{
}
	
GtkProgressBarClass* 
Gtk::ProgressBar::gtk_progress_bar_class() const 
{ 
	return get_class<GtkProgressBarClass>(); 
}
	
Gtk::ProgressBar::operator GtkProgressBar* () const 
{
	return this ? gtk_progress_bar() : 0; 
}
	
String 
Gtk::ProgressBar::get_text() const
{
	return gtk_progress_bar_get_text(gtk_progress_bar());
}

double
Gtk::ProgressBar::get_fraction() const
{
	return gtk_progress_bar_get_fraction(gtk_progress_bar());
}

double
Gtk::ProgressBar::get_pulse_step() const
{
	return gtk_progress_bar_get_pulse_step(gtk_progress_bar());
}
	
Gtk::ProgressBarOrientation
Gtk::ProgressBar::get_orientation() const
{
	return (ProgressBarOrientation)gtk_progress_bar_get_orientation(gtk_progress_bar());
}

void 
Gtk::ProgressBar::pulse()
{
	gtk_progress_bar_pulse(gtk_progress_bar());
}

void 
Gtk::ProgressBar::set_text(const String& text)
{
	gtk_progress_bar_set_text(gtk_progress_bar(), text.c_str());
}

void 
Gtk::ProgressBar::set_fraction(double fraction)
{
	gtk_progress_bar_set_fraction(gtk_progress_bar(), fraction);
}

void 
Gtk::ProgressBar::set_pulse_step(double fraction)
{
	gtk_progress_bar_set_pulse_step(gtk_progress_bar(), fraction);
}

void 
Gtk::ProgressBar::set_orientation(ProgressBarOrientation orientation)
{
	gtk_progress_bar_set_orientation(gtk_progress_bar(), (GtkProgressBarOrientation)orientation);
}

/*  Gtk::ProgressBarClass
 */

void
Gtk::ProgressBarClass::init(GtkProgressBarClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
}

GType
Gtk::ProgressBarClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_PROGRESS_BAR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::ProgressBarClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Properties
 */

const Gtk::ProgressBar::OrientationPropertyType Gtk::ProgressBar::orientation_property("orientation");

const Gtk::ProgressBar::FractionPropertyType Gtk::ProgressBar::fraction_property("fraction");

const Gtk::ProgressBar::PulseStepPropertyType Gtk::ProgressBar::pulse_step_property("pulse_step");

const Gtk::ProgressBar::TextPropertyType Gtk::ProgressBar::text_property("text");

