/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  range.cc - GtkRange C++ wrapper implmentation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "range.h"
#include "private/range_p.h"

using namespace Inti;

/*  Gtk::Range
 */

Gtk::Range::Range(GtkRange *range, bool reference)
: Widget((GtkWidget*)range, reference)
{
}

Gtk::Range::Range()
: Widget((GtkWidget*)RangeClass::create())
{
}

Gtk::Range::~Range()
{
}

GtkRangeClass*
Gtk::Range::gtk_range_class() const 
{ 
	return get_class<GtkRangeClass>(); 
}
	
Gtk::Range::operator GtkRange* () const 
{ 
	return this ? gtk_range() : 0;
}
	
Gtk::UpdateType 
Gtk::Range::get_policy() const
{
	return (UpdateType)gtk_range_get_update_policy(gtk_range());
}

Gtk::Adjustment*
Gtk::Range::get_adjustment() const
{
	return G::Object::wrap<Adjustment>(gtk_range_get_adjustment(gtk_range()));
}

bool 
Gtk::Range::get_inverted() const
{
	return gtk_range_get_inverted(gtk_range());
}

double
Gtk::Range::get_value() const
{
	return gtk_range_get_value(gtk_range());
}

void 
Gtk::Range::set_round_digits(int round_digits)
{
	gtk_range()->round_digits = round_digits;
}

void 
Gtk::Range::set_update_policy(UpdateType policy)
{
	gtk_range_set_update_policy(gtk_range(), (GtkUpdateType)policy);
}

void 
Gtk::Range::set_adjustment(Adjustment *adjustment)
{
	gtk_range_set_adjustment(gtk_range(), *adjustment);
}

void 
Gtk::Range::set_inverted(bool setting)
{
	gtk_range_set_inverted(gtk_range(), setting);
}

void 
Gtk::Range::set_increments(double step, double page)
{
	gtk_range_set_increments(gtk_range(), step, page);
}

void 
Gtk::Range::set_range(double min, double max)
{
	gtk_range_set_range(gtk_range(), min, max);
}

void
Gtk::Range::set_value(double value)
{
	gtk_range_set_value(gtk_range(), value);
}

/*  Gtk::RangeClass
 */

void
Gtk::RangeClass::init(GtkRangeClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
	g_class->get_range_border = &get_range_border_proxy;
	g_class->value_changed = &value_changed_proxy;
	g_class->adjust_bounds = &adjust_bounds_proxy;
}

GType
Gtk::RangeClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_RANGE, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::RangeClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::RangeClass::get_range_border_proxy(GtkRange *range, GtkBorder *border)
{
	Range *tmp_range = G::Object::pointer<Range>(range);
	if (tmp_range)
		tmp_range->do_get_range_border(border);
	else
	{
		GtkRangeClass *g_class = G::TypeInstance::class_peek_parent<GtkRangeClass>(GTK_RANGE_GET_CLASS(range));
		if (g_class->get_range_border)
			g_class->get_range_border(range, border);
	}
}

void
Gtk::RangeClass::value_changed_proxy(GtkRange *range)
{
	Range *tmp_range = G::Object::pointer<Range>(range);
	if (tmp_range)
		tmp_range->on_value_changed();
	else
	{
		GtkRangeClass *g_class = G::TypeInstance::class_peek_parent<GtkRangeClass>(GTK_RANGE_GET_CLASS(range));
		if (g_class->value_changed)
			g_class->value_changed(range);
	}
}

void
Gtk::RangeClass::adjust_bounds_proxy(GtkRange *range, gdouble new_value)
{
	Range *tmp_range = G::Object::pointer<Range>(range);
	if (tmp_range)
		tmp_range->on_adjust_bounds(new_value);
	else
	{
		GtkRangeClass *g_class = G::TypeInstance::class_peek_parent<GtkRangeClass>(GTK_RANGE_GET_CLASS(range));
		if (g_class->adjust_bounds)
			g_class->adjust_bounds(range, new_value);
	}
}

/*  Overridable methods
 */

void

Gtk::Range::do_get_range_border(GtkBorder *border)
{
	GtkRangeClass *g_class = class_peek_parent<GtkRangeClass>(gtk_range_class());
	if (g_class->get_range_border)
		g_class->get_range_border(gtk_range(), border);
}

/*  Signal handlers
 */

void
Gtk::Range::on_value_changed()
{
	GtkRangeClass *g_class = class_peek_parent<GtkRangeClass>(gtk_range_class());
	if (g_class->value_changed)
		g_class->value_changed(gtk_range());
}

void
Gtk::Range::on_adjust_bounds(double new_value)
{
	GtkRangeClass *g_class = class_peek_parent<GtkRangeClass>(gtk_range_class());
	if (g_class->adjust_bounds)
		g_class->adjust_bounds(gtk_range(), new_value);
}

/*  Properties
 */

const Gtk::Range::UpdatePolicyPropertyType Gtk::Range::update_policy_property("update_policy");

const Gtk::Range::AdjustmentPropertyType Gtk::Range::adjustment_property("adjustment");

const Gtk::Range::InvertedPropertyType Gtk::Range::inverted_property("inverted");

/*  Signals
 */

const Gtk::Range::ValueChangedSignalType Gtk::Range::value_changed_signal("value_changed");

const Gtk::Range::AdjustBoundsSignalType Gtk::Range::adjust_bounds_signal("adjust_bounds");

