/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  separator.cc - GtkSeparator, GtkHSeparator and GtkVSeparator C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "separator.h"
#include "private/separator_p.h"

using namespace Inti;

/*  Gtk::Separator
 */

Gtk::Separator::Separator(GtkSeparator *separator, bool reference) 
: Widget((GtkWidget*)separator, reference)
{
}

Gtk::Separator::Separator()
: Widget((GtkWidget*)SeparatorClass::create())
{
}

Gtk::Separator::~Separator()
{
}

GtkSeparatorClass*
Gtk::Separator::gtk_separator_class() const 
{ 
	return get_class<GtkSeparatorClass>();
}
	
Gtk::Separator::operator GtkSeparator* () const 
{ 
	return this ? gtk_separator() : 0; 
}
	
/*  Gtk::SeparatorClass
 */

void
Gtk::SeparatorClass::init(GtkSeparatorClass *g_class)
{
	WidgetClass::init((GtkWidgetClass*)g_class);
}

GType
Gtk::SeparatorClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SEPARATOR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::SeparatorClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::HSeparator
 */

Gtk::HSeparator::HSeparator(GtkHSeparator *hseparator, bool reference) 
: Separator((GtkSeparator*)hseparator, reference)
{
}

Gtk::HSeparator::HSeparator() 
: Separator((GtkSeparator*)HSeparatorClass::create())
{
}

Gtk::HSeparator::~HSeparator() 
{
}

GtkHSeparatorClass* 
Gtk::HSeparator::gtk_hseparator_class() const 
{ 
	return get_class<GtkHSeparatorClass>(); 
}
	
Gtk::HSeparator::operator GtkHSeparator* () const 
{ 
	return this ? gtk_hseparator() : 0; 
}
	
/*  Gtk::HSeparatorClass
 */

void
Gtk::HSeparatorClass::init(GtkHSeparatorClass *g_class)
{
	SeparatorClass::init((GtkSeparatorClass*)g_class);
}

GType
Gtk::HSeparatorClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_HSEPARATOR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::HSeparatorClass::create()
{
	return g_object_new(get_type(), 0);
}

/*  Gtk::VSeparator
 */

Gtk::VSeparator::VSeparator(GtkVSeparator *vseparator, bool reference) 
: Separator((GtkSeparator*)vseparator, reference)
{
}

Gtk::VSeparator::VSeparator() 
: Separator((GtkSeparator*)VSeparatorClass::create())
{
}

Gtk::VSeparator::~VSeparator() 
{
}

GtkVSeparatorClass* 
Gtk::VSeparator::gtk_vseparator_class() const 
{ 
	return get_class<GtkVSeparatorClass>(); 
}
	
Gtk::VSeparator::operator GtkVSeparator* () const 
{ 
	return this ? gtk_vseparator() : 0; 
}
	
/*  Gtk::VSeparatorClass
 */

void
Gtk::VSeparatorClass::init(GtkVSeparatorClass *g_class)
{
	SeparatorClass::init((GtkSeparatorClass*)g_class);
}

GType
Gtk::VSeparatorClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_VSEPARATOR, (GClassInitFunc)init);
	}
	return type;
}

void*
Gtk::VSeparatorClass::create()
{
	return g_object_new(get_type(), 0);
}

