/***************************************************************************
 $RCSfile: directory.h,v $
                             -------------------
    cvs         : $Id: directory.h,v 1.6 2002/09/20 09:01:25 cstim Exp $
    begin       : Tue Dec 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/




/*
 */


#ifndef C_DIRECTORY_H
#define C_DIRECTORY_H

#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <unistd.h>
#include <pwd.h>

#include <string>
#include <openhbci/error.h>

typedef DIR* t_hDIR;
#define DIR_NO_DIRHANDLE 0


namespace HBCI {

/**
 * @short This class allows platform independant access to directories.
 * @author Martin Preuss<martin@aquamaniac.de>
 */
class DLLIMPORT Directory {
private:
    string _name;
    t_hDIR _dirh;

public:
    /**
     * Constructor.
     */
    Directory(string name);
    ~Directory();

    /**
     * Opens the directory for searches.
     * @author Martin Preuss<martin@aquamaniac.de>
     */
    Error openDirectory();

    /**
     * Creates a directory.
     * @author Martin Preuss<martin@aquamaniac.de>
     */
    Error createDirectory(int mode=FILE_CM_WRITE |
                            FILE_CM_READ |
                            FILE_CM_EXEC);

    /**
     * Reads an entry from the directory.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return error object
     * @param entry reference to a string to receive the entry read.
     */
    Error readEntry(string &entry);

    /**
     * Closes the directory for searches. You need to call this if you have finished your
     * search.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return error object
     */
    Error closeDirectory();

    /**
     * Returns the current working directory.
     * This method throws an Error object on error.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return current working directory
     */
    static DLLIMPORT string workingDirectory();

    /**
     * Set the working directory.
     * @author Martin Preuss<martin@aquamaniac.de>
     * @return error object
     * @param name path to the new working directory
     */
    static DLLIMPORT Error setWorkingDirectory(string name);

    /**
     * Returns the users home directory (e.g. "/home/guest")
     */
    static DLLIMPORT string homeDirectory();
};

} /* namespace HBCI */


#endif




