/***************************************************************************
 $RCSfile: user.cpp,v $
                             -------------------
    cvs         : $Id: user.cpp,v 1.10 2003/04/25 01:45:54 aquamaniac Exp $
    begin       : Sun Nov 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "assert.h"
#include "user.h"

namespace HBCI {

User::User(Pointer<Bank> b,
		   Pointer<Medium> m,
		   const string &uid,
		   int ver,
		   const string &name,
		   bool knowsSupportedUPDJobs)
    :_bank(b)
    ,_medium(m)
    ,_userId(uid)
    ,_version(ver)
    ,_userName(name)
    ,_knowsSupportedUPDJobs(knowsSupportedUPDJobs)
{
  //fprintf(stderr,"Constructing user \"%s\".\n", _userId.c_str());
}

User::User(const User &cu){
  *this=cu;
  //fprintf(stderr,"Constructing user \"%s\" (2).\n", _userId.c_str());
}


User::~User(){
  //fprintf(stderr,"User::~User: Destroying user \"%s\".\n", _userId.c_str());
  _medium=0;
  //fprintf(stderr,"User::~User: Destroyed user \"%s\".\n", _userId.c_str());
}


const list<Pointer<Customer> > &User::customers() const{
    return _customers;
}


Pointer<Customer> User::findCustomer(const string &i) const {
    list<Pointer<Customer> >::const_iterator it;

    for (it=_customers.begin(); it!=_customers.end(); it++) {
        //fprintf(stderr," Customer: %s (%s) \n",
        //        (*it).ref().custId().c_str(),
        //        (*it).ref().custName().c_str());
        if ((*it).ref().custId()==i)
            return (*it);
    } // for

    return 0;
}


void User::addCustomer(Pointer<Customer> cust){
    list<Pointer<Customer> >::iterator it;


    if (!cust.isValid())
        throw Error("User::addCustomer()",
                        ERROR_LEVEL_NORMAL,
                        0,
                        ERROR_ADVISE_DONTKNOW,
                        "invalid pointer.");
    for (it=_customers.begin(); it!=_customers.end(); it++) {
        if (*it==cust) {
            // pointer already in list, no problem.
            return;
        }
        if ((*it).ref().custId()==cust.ref().custId())
            // there already is a customer with that name, ERROR !
            throw Error("User::addCustomer()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "customer already exists.");
    } // for
    _customers.push_back(cust);
}

/*
void User::clear(){
  _bank=0;
  _medium=0;
  _customers.clear();
}
*/

/*
bool User::operator==(const User &u) const 
{
    return (_userId == u._userId) &&
	(_bank.ref() == u._bank.ref());
}
*/

} // namespace HBCI

const char* HBCI_User_userId(const HBCI_User *h) 
{
    assert(h);
    return h->userId().c_str();
}
const HBCI_Medium* HBCI_User_medium(const HBCI_User *h)
{
    assert(h);
    return h->medium().ptr();
}
const HBCI_Bank* HBCI_User_bank(const HBCI_User *h)
{
    assert(h);
    return h->bank().ptr();
}
const char* HBCI_User_userName(const HBCI_User *h) 
{
    assert(h);
    return h->userName().c_str();
}
void HBCI_User_setUserName(HBCI_User *h, const char *n)
{
    assert(h);
    h->setUserName(string(n ? n : ""));
}
const list_HBCI_Customer *HBCI_User_customers(const HBCI_User *h)
{
    assert(h);
    return &(h->customers());
}
const HBCI_Customer *HBCI_User_findCustomer(const HBCI_User *h,
					    const char *custId)
{
    assert(h);
    return (h->findCustomer(string(custId ? custId : ""))).ptr();
}
HBCI_Error *HBCI_User_addCustomer(HBCI_User *h,
				  HBCI_Customer *cust,
				  int autoDelete)
{
    assert(h);
    assert(cust);
    HBCI::Pointer<HBCI::Customer> cp = cust;
    cp.setAutoDelete(autoDelete);
    try {
	h->addCustomer(cp);
	return 0;
    }
    catch (HBCI_Error err) {
	return new HBCI_Error(err);
    }
}


void list_HBCI_User_delete(list_HBCI_User *l)
{
    delete l;
}
void list_HBCI_User_iter_delete(list_HBCI_User_iter *l)
{
    delete l;
}
int list_HBCI_User_size(const list_HBCI_User *l)
{
    assert(l);
    return l->size();
}
list_HBCI_User_iter* list_HBCI_User_begin(const list_HBCI_User *l)
{
    assert(l);
    return new list_HBCI_User_iter(l->begin());
}
list_HBCI_User_iter* list_HBCI_User_end(const list_HBCI_User *l)
{
    assert(l);
    return new list_HBCI_User_iter(l->end());
}
const HBCI_User *
list_HBCI_User_iter_get(const list_HBCI_User_iter *l)
{
    assert(l);
    return (**l).ptr();
}
void list_HBCI_User_iter_next(list_HBCI_User_iter *l)
{
    assert(l);
    l->operator++();
}
int list_HBCI_User_iter_equal(const list_HBCI_User_iter *l1, 
			     const list_HBCI_User_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_User_foreach (const list_HBCI_User *list, 
			      list_HBCI_User_cb func,
			      void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_User_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}



