
/*
	$Id: standalone-ssl-server.pike,v 1.1 2002/08/23 14:53:08 pit Exp $
*/


mapping rpc_functions;

void register_rpc_function(string name, function func) {
	rpc_functions += ([ name:func ]);
}


class xmlrpcServer {

inherit SSL.sslport;
inherit "xmlrpc";

int port;
private object master;

private array pike_entities = ({
	"\000", "\001", "\002", "\003", "\004", "\005", "\006", "\007", 
	"\010", "\011", "\012", "\013", "\014", "\015", "\016", "\017", 
	"\020", "\021", "\022", "\023", "\024", "\025", "\026", "\027", 
	"\030", "\031", "\032", "\033", "\034", "\035", "\036", "\037", 
	"\200", "\201", "\202", "\203", "\204", "\205", "\206", "\207", 
	"\210", "\211", "\212", "\213", "\214", "\215", "\216", "\217", 
	"\220", "\221", "\222", "\223", "\224", "\225", "\226", "\227", 
	"\230", "\231", "\232", "\233", "\234", "\235", "\236", "\237", 
	" ", "%", "'", "\"", "+", "&", "=", "/", 
	"#", ";", "\\", "<", ">" 
});

private array http_entities = ({
	"%00", "%01", "%02", "%03", "%04", "%05", "%06", "%07",    
	"%08", "%09", "%0a", "%0b", "%0c", "%0d", "%0e", "%0f", 
	"%10", "%11", "%12", "%13", "%14", "%15", "%16", "%17", 
	"%18", "%19", "%1a", "%1b", "%1c", "%1d", "%1e", "%1f", 
	"%80", "%81", "%82", "%83", "%84", "%85", "%86", "%87", 
	"%88", "%89", "%8a", "%8b", "%8c", "%8d", "%8e", "%8f", 
	"%90", "%91", "%92", "%93", "%94", "%95", "%96", "%97", 
	"%98", "%99", "%9a", "%9b", "%9c", "%9d", "%9e", "%9f", 
	"%20", "%25", "%27", "%22", "%2b", "%26", "%3d", "%2f", 
	"%23", "%3b", "%5c", "%3c", "%3e"
});


string http_encode_string(string f) {
   return replace(f, pike_entities, http_entities);
}

string http_decode_string(string f) {
	return replace(f, http_entities, pike_entities);
}


private string my_certificate = MIME.decode_base64(
"MIICRzCCAbACAQEwDQYJKoZIhvcNAQEFBQAwbDELMAkGA1UEBhMCQVQxDDAKBgNVBAgTA24vYTEN\n"
"MAsGA1UEBxMETGluejETMBEGA1UEChMKcGl0cmljaCBJVDEVMBMGA1UECxMMUE9TIFNvZnR3YXJl\n"
"MRQwEgYDVQQDEwt3d3cucm9vdC5hdDAeFw0wMjA4MDgxMzI4MjVaFw0yOTEyMjMxMzI4MjVaMGwx\n"
"CzAJBgNVBAYTAkFUMQwwCgYDVQQIEwNuL2ExDTALBgNVBAcTBExpbnoxEzARBgNVBAoTCnBpdHJp\n"
"Y2ggSVQxFTATBgNVBAsTDFBPUyBTb2Z0d2FyZTEUMBIGA1UEAxMLd3d3LnJvb3QuYXQwgZ8wDQYJ\n"
"KoZIhvcNAQEBBQADgY0AMIGJAoGATJuL51PEDiS1cbsSaum8bsVWZbmCpyt1HNIbxhgiOuVmwEDq\n"
"T/pj7qGdE4lhSEoeNguMs1UsWrfarRcABrEyVJnPxHRVYFgGtmtBZjyWLE+ebmphfJ1Om1ezoOJV\n"
"N5YxFay29ueYnWhOsxQXSTHR7uGSJxuOKS6zjFc2fA4OjJ0CBCWNqP0wDQYJKoZIhvcNAQEFBQAD\n"
"gYEAGG+GwgJnCzBl5K8NUE1uewr9pAOpactSYjuknUmbnCoiV5XgsSurBKnSClzsaXZfZKdvI/t/\n"
"2jMyVk5PmpOiI64MUZ/2sUtGet8scB8zO6sbhutTygviL7ZfqNpq/ChAKHR64LEx43G2sqc3+Ll/\n"
"XEh/KdgSUMxLGgR1zVzyl1I=\n");

private string my_key = MIME.decode_base64(
"MIICWwIBAAKBgEybi+dTxA4ktXG7EmrpvG7FVmW5gqcrdRzSG8YYIjrlZsBA6k/6Y+6hnROJYUhK\n"
"HjYLjLNVLFq32q0XAAaxMlSZz8R0VWBYBrZrQWY8lixPnm5qYXydTptXs6DiVTeWMRWstvbnmJ1o\n"
"TrMUF0kx0e7hkicbjikus4xXNnwODoydAgQljaj9AoGATA9FfkTnpERBAdtTuDUOMVI71K7K/8hS\n"
"DUfIZvPnwTkofLJPKfrSEQsfT22pKV5SnRceAHd54/ccLjGYD86PJbaHzPo86W547bCCD6RN/L6w\n"
"vXG/tAIrK7hUzYYfgZjA6ATsNUw7hfoiTWktrRdIotMJRJtxw381b1Ob6g8p4KkCQQCN4uZNXcgF\n"
"09sEpB+lAlBm/Geyei8Eheak/cWUdqoMt2T3ct8qPkTI6UwDJK14bNJhg4gHxqTfhbpu7Y7/dWKf\n"
"AkEAijhabuo9oWdrz33PIgIbCwgfndBePPdBWAynqKDRZTMF6NVdiIW7BPuLt5pTmorTIRX8D7b+\n"
"L5K6am+bleYjQwJALRUGw/GKrW6qcwBmrVYpntDSTjJZOrlMzjph3N0eD8L6A54ucWcJnwP5Lm9L\n"
"8uVjU7z5r5bh5OFLTC1nONBeswJAOQNalpMHH15nH0iS+GwVIaKqelZIgww1uEmKBw8C2qQLY32l\n"
"Pc+YUUBU4e55YKWj8tc3Dgr5bryYMDptwskW0wJAL7xDx5w6YytIGrJZXztkO8yc9TWOsdvqIROl\n"
"kgr9xrTdMm27mK+CXqfMiPRaLUay3dxE7pt8Zkkopm7rhIqa9A==\n");


class Connection {
	import Stdio;
	object SSLconnection;
	object xmlrpc;
	object parent;
	mapping request;
	mapping variables;
	mapping headers;
	mapping http_auth;
	int authorized;

	int answer_index;
	string answer;

	void write_callback() {
		if(strlen(answer)) {
			if (answer_index < strlen(answer)) {
				int written = SSLconnection->write(answer[answer_index..]);
				if (written > 0) {
					answer_index += written;
				} else {
					SSLconnection->close();
				}
			}
			if (answer_index == strlen(answer)) {
				SSLconnection->close();
			}
		}
	}

	void read_callback(mixed id, string data) {
		array raw_request = data / "\r\n\r\n";
		array raw_headers = raw_request[0] / "\r\n";
		string raw_content = raw_request[1];

		int rc = sscanf(raw_headers[0], "%s %s %s",
			request->method,
			request->path,
			request->protocol
		);

		// parse headers
		foreach(raw_headers[1..], string raw_header) {
			array raw = raw_header / ": ";
			if(sizeof(raw) == 2) {
				if(search(raw[1], ",") != -1) {
					headers[raw[0]] = mkmultiset(raw[1]/", ");
				} else {
					headers[raw[0]] = raw[1];
				}
			}
		}

		// parse request
		if(rc != 3) {
			if(headers->Accept["text/html"]) {
				http_string_answer(sprintf("<html><head>"
					"<title>500 - invalid request</title>"
					"</head><body><h1>500 - invalid request</h1>"
					"<p>Malformed HTTP request <b>'%s'</b>."
					"</p></body></html>",
					raw_headers[0]), "text/html", 500
				);
			} else {
				http_string_answer(xmlrpc->compose_fault(3, 
					sprintf("Malformed HTTP request '%s'", raw_headers[0])));
			}
			SSLconnection->set_write_callback(write_callback);
			return;
		}

		multiset allowed_methods=(<"post", "get">);

		if(!allowed_methods[lower_case(request->method)]) {
			if(headers->Accept["text/html"]) {
				http_string_answer(sprintf("<html><head>"
					"<title>405 - method not allowed</title>"
					"</head><body><h1>405 - method not allowed</h1>"
					"<p>Method <b>'%s'</b> is not allowed on this object."
					"</p></body></html>",
					request->method), "text/html", 405
				);
			} else {
				http_string_answer(xmlrpc->compose_fault(3, 
					sprintf("Method '%s' not allowed", id->method)));
			}
			SSLconnection->set_write_callback(write_callback);
			return;
		}


		// check for variables in path
		request->path = http_decode_string(request->path);
		if(search(request->path, "?") != -1) {
			array rawvar=request->path/"?";
			
			if(sizeof(rawvar) == 2) {
				request->path = rawvar[0];
				array raw_vars=({});
				if(search(rawvar[1], "&") != -1) {
					raw_vars = rawvar[1] / "&";
				} else {
					raw_vars = ({ rawvar[1] });
				}
				foreach(raw_vars, string rvar) {
					array pair=rvar/"=";
					if(sizeof(pair) == 2) {
						variables[pair[0]] = pair[1];
					} else {
						variables[rvar] = 1;
					}
				}
			}

		}

		// get client address
		array client_connection=SSLconnection->query_address() / " ";
		request->client_ip = client_connection[0];
		request->client_port = client_connection[1];
		
	
		// parse http auth
		if(headers->Authorization && strlen(headers->Authorization)) {
			string raw=headers->Authorization-"Basic ";
			raw = MIME.decode_base64(raw);
			array A=raw/":";
			if(sizeof(A) == 2) {
				http_auth->user=A[0];
				http_auth->pass=A[1];
				authorized=1;
			}
		}
	
		// debug info request
		if(lower_case(request->method) == "get") {
			if(request->path == "/_debug.html" || variables->_debug) {
				http_string_answer(sprintf("<html><head>"
					"<title>debug information</title></head><body>"
					"<h1>Debug Information</h1>"
					"<br>request:<br><pre>%O</pre><br>headers:<br><pre>%O</pre>"
					"<br>auth:<br><pre>%O</pre><br>variables:<br><pre>%O</pre>",
						request, headers, http_auth, variables),
						"text/html");
			} else {
				http_string_answer(sprintf("<html><head>"
					"<title>404 - page not found</title>"
					"</head><body><h1>404 - page not found</h1>"
					"<p>The requested page is not available"
					"</p></body></html>"), "text/html", 405
				);
			}
			SSLconnection->set_write_callback(write_callback);
			return;
		} else {
			// process xmlrpc request
			function    call;
			string xmlResult;
			mixed callResult;
			string     fcall;
			mixed       args;
			mapping      rpc;

			mixed err=catch {
				rpc = xmlrpc->parse(raw_content);
			};

			if(err) {
				http_string_answer(xmlrpc->compose_fault(3,
            	"Error parsing xmlrpc reuest"));
				SSLconnection->set_write_callback(write_callback);
				return;
			}

			fcall = rpc["methodName"];
			args  = rpc["params"];

			// default return
			xmlResult = xmlrpc->compose_fault(4,
				sprintf("Function '%s' not found", fcall));

			call = rpc_functions[fcall];

			if (functionp(call)) {
				callResult = call(@args);
				xmlResult = xmlrpc->compose_response(callResult);
			}
			
			http_string_answer(xmlResult);
			SSLconnection->set_write_callback(write_callback);
			return;
		}

		if(headers->Accept["text/html"]) {
			http_string_answer(sprintf("<html><head>"
				"<title>500 - internal server error</title>"
				"</head><body><h1>500 - internal server error</h1>"
				"<p>Internal Server error occured."
				"</p></body></html>",
				request->method), "text/html", 405
			);
		} else {
			http_string_answer(xmlrpc->compose_fault(3, 
				"Internal Server Error"));
		}
		SSLconnection->set_write_callback(write_callback);
		return;
	}

	void http_string_answer(string data, string|void _type, int|void _code)
	{
		string contenttype=_type || "text/xml";
		int code=_code || 200;
		string codestr = (code==200?"OK":"Error");
		string rc="";

		rc += sprintf("%s %d %s\r\n", request->protocol, code, codestr);
		rc += sprintf("Connection: close\r\n");
		rc += sprintf("Content-Length: %d\r\n", (data?strlen(data):0));
		rc += sprintf("Content-Type: %s\r\n", contenttype);
		rc +=	sprintf("Server: Pike xmlRPC backend/0.0.1\r\n\r\n");
		rc += sprintf("%s", data);
		answer = rc;
	}


	void create(object f, object _parent) {
		SSLconnection = f;
		xmlrpc=xmlRPC();

		parent = _parent;	

		request = ([]);
		variables = ([]);
		headers = ([]);

		http_auth = ([ "user":"", "pass":"" ]);
		authorized = 0;

		answer_index = 0;
		answer = "";
		
		SSLconnection->set_nonblocking(read_callback, 0, 0);
	}
};


private class no_random {
	object arcfour = Crypto.arcfour();
  
	void create(string|void secret) {
		if (!secret) {
			secret = sprintf("_$#23487dafl#@$ASDF@#$&*&Foo!%4c", time());
		}
		object sha = Crypto.sha();
		sha->update(secret);
		arcfour->set_encrypt_key(sha->digest());
	}

	string read(int size) {
		return arcfour->crypt(replace(allocate(size), 0, "\021") * "");
	}
};


private void https_accept_callback(object f) {
	Connection(accept(), this_object());
}


int create(void|int _port, void|object _master) {
	port = _port || 443;
	master = _master || 0;
	rpc_functions = ([]);
	sslport::create();
	rsa = Standards.PKCS.RSA.parse_private_key(my_key);
	certificates = ({ my_certificate });
	random = no_random()->read;
}

int start() {
	if (!bind(port, https_accept_callback)) {
		return -1;
	}
	return 0;
}

}; // class xmlrpcServer

/*
int test_int(int foo) {
	return foo+10;
}


int main() {
	object s=xmlrpcServer(443, this_object());
	register_rpc_function("test_int", test_int);
	s->start();
	return -17;
}
*/

// vi: set ts=3:
