/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */

/* WARNING use these functions carefully as they do little error
   checking. They are designed to run fast in tight loops. */

#define LINE_BUFFER		1
#define NO_BUFFER		2
#define PRINT_ENTRY_EXIT	4


/* Initializes the logging program. Takes a filename to write the log messages to.
 * Setting crash_finder to true will print out all the level entry and exits and
 * turn off buffering so that all messages are written out to the file on disk.
 * This makes sure all messages are printed to the file before the program
 * crashes. */
int masc_init_log_program(char *filename, char *first_log_title, int options);

/* Shuts down the logger. */
void masc_exit_log_program(void);

/* Takes a message to print to the log file and a verbosity level, if the message
 * verbosity is less than or equal to the current level of verbosity
 * then the message is printed to the file */
void masc_log_message(int verbosity, char *format, ...);

/* Sets the programs current verbosity level. All messages less than or equal to
 * this level will be printed. */
void masc_log_verbosity(int verbosity);

/* Called when a new log level is being entered and takes a pointer to a string
 * naming the log level. */
void masc_entering_log_level(char *log_title);

/* Called when exiting a log level */
void masc_exiting_log_level(void);

