/*


    ========== licence begin GPL
    Copyright (C) 2002-2003 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


*/

package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.*;
/**
 *
 */
abstract class BinaryDataTranslator extends DBTechTranslator {
    /**
     *
     * @param mode int
     * @param ioType int
     * @param dataType int
     * @param len int
     * @param ioLen int
     * @param bufpos int
     */
    BinaryDataTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos) {
        super(mode, ioType, dataType, len, ioLen, bufpos);
    }
    /**
     *
     * @param dataPart com.sap.dbtech.jdbc.packet.DataPart
     * @param data java.lang.Object
     */
    protected void putSpecific (DataPart dataPart, Object data)
    throws java.sql.SQLException
    {
        byte [] bytes = (byte []) data;
        dataPart.putInt1 (0, this.bufpos - 1);
        dataPart.putBytes (bytes, this.bufpos, this.physicalLength - 1);
    }
}
