# ------------------------------------------------------------------------------
#
# Kernel Descriptions
#
# ------------------------------------------------------------------------------
#
#
#    ========== licence begin  GPL
#    Copyright (c) 2000-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#

#


regex(.*\.cpp$)    -except

# -------------------------------------------------------------------------------------
# Errors and messages:
# -------------------------------------------------------------------------------------
#

Kernel_Messages.genmsg          ascii

Kernel_Messages.hpp             inc=SAPDBErr_MessageList.hpp
Kernel_Event_Messages.hpp       inc=SAPDBErr_MessageList.hpp

Kernel_Exception.hpp            inc=SAPDBErr_MessageList.hpp

# -------------------------------------------------------------------------------------
# Interfaces and basis types:
# -------------------------------------------------------------------------------------
#
Kernel_Common.hpp               inc=SAPDB_Types.hpp,SAPDBErr_Assertions.hpp,SAPDBTrace_Usage.hpp

Kernel_Types.hpp                inc=SAPDBTrace_Topic.hpp,\
                                    SAPDBDiag_CheckTopic.hpp


Kernel_DateTime.hpp             inc=SAPDB_Types.hpp,\
                                    SAPDB_EnhancedTypes.hpp,\
									RTESys_Time.h


# -------------------------------------------------------------------------------------
# Page:
# -------------------------------------------------------------------------------------
#
Kernel_IPage.hpp                inc=SAPDB_Types.hpp,\
                                    SAPDBFields_Field.hpp

Kernel_Page.hpp                 inc=ggg00,\
                                    SAPDB_PersistentTypes.hpp,\
                                    Kernel_IPage.hpp

Kernel_Page72.hpp               inc=Kernel_Page.hpp,\
                                    SAPDB_PersistentTypes.hpp,\
                                    Kernel_Exception.hpp,\
                                    Kernel_Messages.hpp,\
                                    RTE_Message.hpp

Kernel_Page74.hpp               inc=Kernel_Page.hpp,\
                                    Kernel_Exception.hpp,\
                                    Kernel_Messages.hpp,\
                                    RTE_Message.hpp

Kernel_Page74.cpp               inc=Kernel_Page74.hpp

Kernel_RestartPage.hpp          inc=gkb00,\
                                    Kernel_Page72.hpp,\
                                    SAPDBErr_Assertions.hpp,\
                                    SAPDB_Types.hpp

Kernel_RestartPage.cpp          inc=ggg00,\
                                    hgg01_3.h,\
                                    Kernel_Page.hpp,\
                                    Kernel_RestartPage.hpp

Kernel_DumpPage.hpp             inc=Kernel_Common.hpp,\
                                    Kernel_Page.hpp,\
                                    SAPDBFields_Field.hpp

# -------------------------------------------------------------------------------------
# Task Main:
# -------------------------------------------------------------------------------------
#
Kernel_TaskMain.h               inc=
Kernel_TaskMain.cpp             inc=Kernel_TaskMain.h

# -------------------------------------------------------------------------------------
# Test:
# -------------------------------------------------------------------------------------
#
Kernel_Test.hpp             inc=ggg00
Kernel_Test.cpp             inc=Kernel_Test.hpp,\
                                Kernel_Migration.hpp,\
                                Kernel_Version.hpp

# -------------------------------------------------------------------------------------
# Taask Wait List
# -------------------------------------------------------------------------------------

Kernel_TaskWaitList.hpp  inc=SAPDB_Types.hpp,\
                             SAPDBErr_Assertions.hpp,\
                             RTE_Crash.hpp,\
                             gsp00,\
                             ggg00,\
                             heo56.h,\
                             heo51.h

# -------------------------------------------------------------------------------------
# Monitoring
# -------------------------------------------------------------------------------------

Kernel_Event.hpp         inc=SAPDB_Types.hpp,\
                             vsp0031

Kernel_Event.cpp         inc=Kernel_Event.hpp,\
                             heo60.h,\
                             hgg01_2.h,\
                             SAPDBErr_MessageList.hpp,\
                             RTE_Message.hpp,\
                             SAPDB_ToString.hpp,\
                             Kernel_Event_Messages.hpp

# ------------------------------------------------------------------------------
# Kernel Statistic
# ------------------------------------------------------------------------------

Kernel_TableStatistic.hpp   inc=ggg00,\
                                Kernel_Common.hpp

# -------------------------------------------------------------------------------------
# old style tracing
# -------------------------------------------------------------------------------------
#
Kernel_VTrace.hpp inc=ggg00,SAPDB_OStream.hpp
Kernel_VTrace.cpp inc=heo51.h,Kernel_VTrace.hpp,Trace_Entry.hpp
Kernel_OpMsg.hpp  inc=gsp03,ggg00,SAPDB_OStream.hpp
Kernel_OpMsg.cpp  inc=Kernel_OpMsg.hpp,heo60.h

# -------------------------------------------------------------------------------------
# new style tracing
# -------------------------------------------------------------------------------------
#
Kernel_TraceTopics.cpp          inc=gsp00,ggg00,hgg941.h,heo51.h,\
                                    RTEMem_Allocator.hpp,\
                                    RTESync_Spinlock.hpp,\
                                    Trace_Entry.hpp,\
                                    SAPDBDiag_CheckTopic.hpp,\
                                    SAPDBTrace_Topic.hpp,\
                                    SAPDBTrace_Stream.hpp,\
                                    Kernel_TraceTopics.hpp

Kernel_Trace.hpp                inc=ggg00,SAPDB_Types.hpp
Kernel_Trace.cpp                inc=Kernel_Trace.hpp,\
                                    SAPDBTrace_Topic.hpp,\
                                    SAPDBTrace_Stream.hpp,\
                                    SAPDB_sprintf.h,\
                                    Kernel_VTrace.hpp,\
                                    gsp00,ggg00,hgg17.h

# -------------------------------------------------------------------------------------
# Kernel FileIO and Kernel dump
# -------------------------------------------------------------------------------------

Kernel_FileIO.hpp               inc=gsp00,\
                                    Kernel_Common.hpp,\
                                    Kernel_IPage.hpp

Kernel_FileIO.cpp               inc=heo51.h,\
                                    heo55k.h,\
                                    heo66.h,\
                                    hsp77.h,\
                                    hgg08.h,\
                                    Kernel_FileIO.hpp,\
                                    Kernel_Exception.hpp,\
                                    Kernel_Messages.hpp,\
                                    RTE_Message.hpp

Kernel_Dump.hpp                 inc=gsp00,\
                                    Kernel_Common.hpp,\
                                    Kernel_DumpPage.hpp,\
                                    KernelCommon/Kernel_FileIO.hpp,\
                                    KernelCommon/Kernel_IPage.hpp

Kernel_Dump.cpp                 inc=heo58.h,\
                                    Kernel_Dump.hpp

# -------------------------------------------------------------------------------------
# Types for describing indexes and blobs
# -------------------------------------------------------------------------------------
Kernel_IndexDescription.hpp     inc=SAPDB_Types.hpp,\
                                    SAPDB_EnhancedTypes.hpp,\
                                    Container_Vector.hpp
Kernel_IndexDescription.cpp     inc=SAPDB_Types.hpp,\
                                    SAPDB_EnhancedTypes.hpp,\
                                    Kernel_IndexDescription.hpp,\
                                    SAPDBErr_Assertions.hpp
Kernel_BlobDescription.hpp      inc=SAPDB_Types.hpp,\
                                    SAPDB_EnhancedTypes.hpp,\
                                    Container_Vector.hpp
Kernel_BlobDescription.cpp      inc=SAPDB_Types.hpp,\
                                    Kernel_BlobDescription.hpp
   
# -------------------------------------------------------------------------------------
# Kernel Manager (previous utility)
# -------------------------------------------------------------------------------------
Kernel_State.hpp                 inc=RTESync_NamedSpinlock.hpp
Kernel_IAdminConfig.hpp          inc=SAPDB_Types.hpp,Log_Types.hpp,gsp00
Kernel_IAdminDiagnose.hpp        inc=SAPDB_Types.hpp,gsp00,\
                                     Data_Types.hpp
Kernel_IAdminInfo.hpp            inc=gsp00,SAPDB_Types.hpp,Log_Types.hpp
Kernel_IAdminRestartShutdown.hpp inc=Kernel_DateTime.hpp,\
                                     Log_Types.hpp
Kernel_IAdminHotStandby.hpp      inc=SAPDB_Types.hpp,\
                                     Kernel_DateTime.hpp,\
                                     Log_Types.hpp,\
                                     gsp00
Kernel_IAdminBackupRecovery.hpp  inc=gsp00,\
                                     ggg00,\
                                     Kernel_DateTime.hpp,\
                                     Rst_Types.hpp
Kernel_Administration.hpp        inc=Kernel_IAdminRestartShutdown.hpp,\
                                     Kernel_IAdminHotStandby.hpp,\
                                     Kernel_IAdminBackupRecovery.hpp,\
                                     Kernel_IAdminInfo.hpp,\
                                     Kernel_IAdminConfig.hpp,\
                                     Kernel_IAdminDiagnose.hpp,\
                                     Kernel_State.hpp,\
                                     Kernel_Migration.hpp,\
                                     RTEMem_AllocatorWrapper.hpp,\
                                     RTESync_NamedSpinlock.hpp,\
                                     SAPDB_Singleton.hpp,\
                                     Rst_RedoManager.hpp,\
                                     Rst_Types.hpp
Kernel_Administration.cpp        inc=SAPDB_sprintf.h,\
                                     SAPDBMem_IRawAllocator.hpp,\
                                     SAPDBMem_NewDestroy.hpp,\
                                     SAPDBErr_Assertions.hpp,\
                                     SAPDBTrace_Usage.hpp,\
                                     RTE_Message.hpp,\
                                     RTE_ISystem.hpp,\
                                     RTEHSS_KernelInterface.hpp,\
                                     RTEHSS_StandbyNodeList.hpp,\
                                     RTEConf_ParameterAccessKernelInterface.hpp,\
                                     Kernel_Types.hpp,\
                                     Kernel_DateTime.hpp,\
                                     Kernel_Messages.hpp,\
                                     Kernel_Exception.hpp,\
                                     Kernel_Version.hpp,\
                                     Kernel_Administration.hpp,\
                                     Kernel_RestartPage.hpp,\
                                     Log_Types.hpp,\
                                     Log_Savepoint.hpp,\
                                     Log_Volume.hpp,\
                                     Log_History.hpp,\
                                     FrameCtrl_ILog.hpp,\
                                     IOMan_ILogInfo.hpp,\
                                     IOMan_IDataInfo.hpp,\
                                     IOMan_ILogManager.hpp,\
                                     IOMan_IDataManager.hpp,\
                                     IOMan_IDataIO.hpp,\
                                     IOMan_IDiagnose.hpp,\
                                     IOMan_BlockAddress.hpp,\
                                     IOMan_ReservedBlockAddress.hpp,\
                                     IOMan_IDataVolumeInfo.hpp,\
                                     IOMan_ILogVolumeInfo.hpp,\
                                     Converter_IBackUp.hpp,\
                                     Converter_ICommon.hpp,\
                                     Converter_IManager.hpp,\
                                     Converter_IDiagnose.hpp,\
                                     Catalog_Interface.hpp,\
                                     Data_Types.hpp,\
                                     SQLManErr_Interface.hpp,\
                                     ggg92.h,ggg00,\
                                     hsp20.h,\
                                     heo47.h,heo51.h,heo79.h,heo58.h,heo60.h,heo670.h,\
                                     hak10.h,\
                                     hgg01_3.h,hgg10.h,hgg17.h,\
                                     hbd01.h,hbd01_1.h,hbd02.h,hbd03.h,hbd05.h,hbd06.h,\
                                     hbd14.h,hbd17.h,hbd20.h,\
                                     hkb51.h,hkb53.h,hkb57.h,hkb57_1.h,\
                                     hkb38.h,hkb38_1.h,hkb90.h
# -------------------------------------------------------------------------------------
# Kernel Version and Migration
# -------------------------------------------------------------------------------------
Kernel_Version.hpp               inc=SAPDB_Types.hpp,\
                                     SAPDB_EnhancedTypes.hpp,\
                                     gsp00
Kernel_Version.cpp               inc=Kernel_Version.hpp,\
                                     gsp100.h,\
                                     hgg11.h,\
                                     RTE_Message.hpp,\
                                     RTE_Crash.hpp,\
                                     SAPDBErr_Assertions.hpp,\
                                     SAPDB_ToString.hpp,\
                                     Kernel_Messages.hpp,\
                                     Kernel_Exception.hpp,\
                                     Kernel_Version.hpp
# -------------------------------------------------------------------------------------
Kernel_MigrationMatrix.hpp       dep=:config/Buildinfo/VERSIONS,:config/Persinfo/VERSIONS.persinfo \
                                     setbuildinfo
Kernel_Migration.hpp             inc=Kernel_Version.hpp
Kernel_Migration.cpp             inc=Kernel_Migration.hpp,\
                                     Kernel_MigrationMatrix.hpp,\
                                     RTE_Message.hpp,\
                                     RTE_Crash.hpp,\
                                     SAPDBErr_Assertions.hpp,\
                                     SAPDB_ToString.hpp,\
                                     Kernel_Types.hpp,\
                                     Kernel_Messages.hpp,\
                                     Kernel_Exception.hpp,\
                                     Kernel_Version.hpp,\
                                     hgg01.h
# -------------------------------------------------------------------------------------
&if $OSSPEC == LINUX && $MACH in [ S390X, IA64 ]
regex(\w+\.cpp) -OPT=-O2
&endif

