/*!
  -----------------------------------------------------------------------------

  module: DBMSrv_Common.hpp

  -----------------------------------------------------------------------------

  responsible:  BerndV

  special area: DBMServer Common 

  description:  Common specifications for DBMServer area

  -----------------------------------------------------------------------------

  copyright: 


    ========== licence begin  GPL
    Copyright (c) 2002-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end



  -----------------------------------------------------------------------------
*/

#ifndef _DBMSrv_Common_HPP_
#define _DBMSrv_Common_HPP_
/*
  -----------------------------------------------------------------------------
  includes
  -----------------------------------------------------------------------------
 */
#include "SAPDBCommon/ErrorsAndMessages/SAPDBErr_MessageList.hpp"
#include "gcn00_1.h"

#define DBMSrv_ExtendedError(p)      "DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, (SAPDBErr_MessageList::MessageID) p
#define DBMSrv_DBMError(p)           "DBM", __FILE__, __LINE__, SAPDBErr_MessageList::Error, cn00_1_ErrId( ERR_##p##_CN00_1 ), cn00_1_ErrTxt( ERR_##p##_CN00_1 )


#define DBMSRV_ERR_MISSDBUSRPWD      DBMSrv_ExtendedError(-1), "Missing database, user or password", 0
#define DBMSRV_ERR_UNKNOWNTASK       DBMSrv_ExtendedError(-1), "Unknown task type", 0
#define DBMSRV_ERR_WRONGREPLY        DBMSrv_ExtendedError(-1), "Wrong reply from kernel received", 0
#define DBMSRV_ERR_HSSNODEUNKNOWN    DBMSrv_ExtendedError(-1), "The requested node is not known", 0
#endif /* _DBMSrv_Common_HPP_ */
