#!/usr/bin/perl
#
# module:    runtests.pl
#
# responsible: D030044
#
# special area: Script for running all MaxDB PHP tests
# description:  
#
# see:
# 
# change history:
#
#    ========== licence begin  GPL
#    Copyright (c) 2001-2004 SAP AG
#
#    This program is free software; you can redistribute it and/or
#    modify it under the terms of the GNU General Public License
#    as published by the Free Software Foundation; either version 2
#    of the License, or (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#    ========== licence end
#
package runtests;

use Env;
use File::Copy;
use Getopt::Long;
use POSIX qw(tmpnam);

sub usage;
sub _moved2u;
sub _rename;
sub _doperl;

if ( defined $ENV{OS} && ($ENV{OS} eq "WIN32" || $ENV{OS} eq "Windows_NT") ) {
  $EXEC_EXT = ".exe";
} else {
  $EXEC_EXT = "";
}

GetOptions( 'node|n=s' => \$nodename,
            'database|d=s' => \$dbname,
            'user|u=s' => \$userpwd,
            'help|h|?' => \$help) or usage();

if( $help) {
  usage();
}

($user, $password) = split /,/, $userpwd;

if ($nodename eq '') {
  $nodename=$ENV{'SERVERNODE'};
}
if ($dbname eq '') {
  $dbname=$ENV{'SERVERDB'};
}
if (($user eq '') || ($password eq '')) {
  $user=$ENV{'SUPERUID'};
  $password=$ENV{'SUPERPWD'};
}

$user = uc($user);
$password = uc($password);

$INFILE="$INSTROOT/lib/php.ini";

if (! -f "$INFILE" ) {
  die "$INFILE not found";
}

$BAKFILE=tmpnam();
$OUTFILE=tmpnam();

copy($INFILE, $BAKFILE) || warn "Can't copy $INFILE to $BAKFILE";

$hasmaxdb = 0;
$hashost = 0;
$hasdb = 0;
$hasuser = 0;
$haspw = 0;

if ( -f "$INFILE" ) {
  $temp=$\;$\="";
  open(FILE_IN, "<$INFILE") || die "Can't open $INFILE (input): $!";
  while(<FILE_IN>) {
    if ( /\[maxdb\]/ ) {
      $hasmaxdb = 1;
    }
    if ( /maxdb.default_host =/ ) {
      $hashost = 1;
    }
    if ( /maxdb.default_db =/ ) {
      $hasdb = 1;
    }
    if ( /maxdb.default_user =/ ) {
      $hasuser = 1;
    }
    if ( /maxdb.default_pw =/ ) {
      $haspw = 1;
    }
  }
  close(FILE_IN);
  $\=$temp;
}

if ($hasmaxdb eq 1) {
  if ( -f "$INFILE" ) {
    $temp=$\;$\="";
    open(FILE_IN, "<$INFILE") || die "Can't open $INFILE (input): $!";
    open(FILE_OUT, ">$OUTFILE") || die "Can't open $OUTFILE (output): $!";
    while(<FILE_IN>) {
      if (/\[maxdb\]/) {
	if ($hashost eq 0) {
	  print FILE_OUT $_;
	  print FILE_OUT "maxdb.default_host = $nodename\n";
	  next;
	}
	if ($hasdb eq 0) {
	  print FILE_OUT $_;
	  print FILE_OUT "maxdb.default_db = $dbname\n";
	  next;
	}
	if ($hasuser eq 0) {
	  print FILE_OUT $_;
	  print FILE_OUT "maxdb.default_user = $user\n";
	  next;
	}
	if ($haspw eq 0) {
	  print FILE_OUT $_;
	  print FILE_OUT "maxdb.default_pw = $password\n";
	  next;
	}
      }
      s/maxdb.default_host =.*/maxdb.default_host = $nodename/g;
      s/maxdb.default_db =.*/maxdb.default_db = $dbname/g;
      s/maxdb.default_user =.*/maxdb.default_user = $user/g;
      s/maxdb.default_pw =.*/maxdb.default_pw = $password/g;
      print FILE_OUT $_;
    }
    close(FILE_OUT); close(FILE_IN);
    $\=$temp;
  }
} else {
  if ( -f "$INFILE" ) {
    $temp=$\;$\="";
    open(FILE_IN, "<$INFILE") || die "Can't open $INFILE (input): $!";
    open(FILE_OUT, ">$OUTFILE") || die "Can't open $OUTFILE (output): $!";
    while(<FILE_IN>) {
      if (/\[MySQL\]/) {
	print FILE_OUT "[maxdb]\n";
	print FILE_OUT "maxdb.default_host = $nodename\n";
	print FILE_OUT "maxdb.default_db = $dbname\n";
	print FILE_OUT "maxdb.default_user = $user\n";
	print FILE_OUT "maxdb.default_pw = $password\n";
	print FILE_OUT "\n";
      }
      print FILE_OUT $_;
    }
    close(FILE_OUT); close(FILE_IN);
    $\=$temp;
  }
}
_moved2u ("$OUTFILE", "$INFILE");

print "Using connectoptions:\n";
print "  node     = $nodename\n";
print "  dbname   = $dbname\n";
print "  username = $user\n";
print "  password = $password\n";
print "\n";

$ENV{TEST_PHP_EXECUTABLE} = "$ENV{INSTROOT}/pgm/php$EXEC_EXT";
system("$ENV{TEST_PHP_EXECUTABLE} run-tests.php .");

copy($BAKFILE, $INFILE) || warn "Can't copy $BAKFILE to $INFILE";

sub _moved2u
{
    _rename $_[0], $_[1];
    _doperl( "d2u$TOOLEXT $_[1]" );
}

sub _rename
{
    my $OLDFILE=$_[0];
    my $NEWFILE=$_[1];
    unlink ("$NEWFILE");    
    copy ("$OLDFILE", "$NEWFILE");
    unlink ($OLDFILE);
}

sub _doperl
{
    local @tmp = @ARGV;
    local $lsep = $\;$\="";

    local @args = split (' ', $_[0]);
    local $perlsrc = @args[0];
    local $n = @args-1;
    @ARGV = @args[1..$n];
    do $perlsrc;
    @ARGV = @tmp;
    $\=$lsep;
}

sub usage {
  print <<end;
runtests.pl

runtests.pl - run the tests of the MaxDB PHP Testsuite

SYNOPSIS

\truntests.pl [-n node] [-d dbname] [-u username,password]

DESCRIPTION
\tRuns the tests of the MAxDB PHP Testsuite. If not specified at command
\tline, the environment variables SERVERDB, SERVERNODE, SUPERUID and SUPERPWD 
\tare inspected to get values for database name, user and password.

\t-n <node>
\t\tRuns the tests using a database running on the host <node>.

\t-d <dbname>
\t\tRuns the tests using a database named <dbname>.

\t-u <username>,<password>
\t\tRuns the tests using an user <username> having a password
\t\t<password>.
end

  exit(1);
}
