/*!
  @file           SQLDBC_Proxy.h
  @author         D039759
  @ingroup        SQLDBC
  @brief          External interface to the proxy runtime.
  @see            

\if EMIT_LICENCE

    ========== licence begin  GPL
    Copyright (c) 2001-2004 SAP AG

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
    ========== licence end


\endif
*/
#ifndef SQLDBC_PROXY_H
#define SQLDBC_PROXY_H

#include "SQLDBC_Types.h" /* no check */

class SQLDBC_IRuntime;
class SQLDBC_IProxyRuntime;

SQLDBC_DLLEXPORT SQLDBC_IRuntime *GetProxyRuntime(char *errorText, const SQLDBC_Int4 errorTextSize);
SQLDBC_DLLEXPORT SQLDBC_Bool SQLDBC_Proxy_GetChallenge(SQLDBC_IRuntime *proxyRuntime,
                                                       const char *servernode,
                                                       const char *serverdb,
                                                       SQLDBC_Int8&   sessionid,
                                                       char          *challenge,
                                                       SQLDBC_Length& challengeLength,
                                                       char          *errortext,
                                                       SQLDBC_Length  errortextLength);

#endif
   
