#/*!
#\@file           genSQLDBCdoc.pl
#\@author         DL SAP DB INTERFACES
#\@ingroup        SQLDBC
#\@brief          SAP Database Connectivity
#\@see            
#
#       This script patches the generated doxygen documentation 
#       for the c++ interface SQLDBC
#
#\\if EMIT_LICENCE
#
#	========== licence begin  GPL
#	Copyright (c) 2001-2004 SAP AG
#
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License
#	as published by the Free Software Foundation; either version 2
#	of the License, or (at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#	========== licence end
#
#
#\\endif
#*/

#use strict;
use Env;
use File::Path;
use Getopt::Long;
use Getopt::Std;
use File::Copy;

my @doxygendirs = ("$ENV{OWN}/tool/bin/", "$ENV{TOOL}/pgm/", "");

my $dotexe=".exe" if($^O=~/.*win32.*/i);
my $doxygen;
my $doxyver="1.3-rc2";
my $package="SQLDBC-MAN.TGZ";
my $doxyfile="$ENV{WRK}/fast/obj/SAPDB/Interfaces/SQLDBC/";

my $cmd;
GetOptions("dir=s", "with-floss", "help") || usage();

if (!getopts ('h') || $opt_help || !$opt_dir) {
    usage();
}

if (-d "$opt_dir") {
    chdir("$opt_dir");
    unlink <*>;
}

my $found=0;
my $versionok=0;
foreach my $dir (@doxygendirs) {
    $doxygen="${dir}doxygen$dotexe";
    if (-x "$doxygen") {
        $found=1;
        if (checkDoxygenVersion($doxygen, $doxyver)) {
            $versionok=1;
            last;
        }
    }
}
if (!$found) {
    print "ERROR: Could not found $doxygen\n";
    exit 1;    
}
else {
    if (!$versionok) {
        print "ERROR: Wrong doxygen version '$ver' nedded '$doxyver'\n";
        exit 1;    
    }
}

if ($opt_with_floss) {
    $doxyfile.="SQLDBC-FLOSS.doxygen"
}
else {
    $doxyfile.="SQLDBC.doxygen"
}
$cmd = "$doxygen $doxyfile";
print "$cmd\n";
if(system($cmd)) {
    print "ERROR: Can't generate documentation\n";
    exit 1;
}

my $infile = "$opt_dir/tree.js";
my $outfile = "$opt_dir/tree.js.tmp";
open(FILE_IN, "<$infile") || die "Can't open '$infile' (input): $!";
open(FILE_OUT, ">$outfile")  || die "Can't open '$outfile' (output): $!";
my $firstline=1;
while(<FILE_IN>) {
#
#   Skip if already modified
#
    if ($_=~/\/\/ tree.js modified by genSQLDBCdoc/) {
        exit 0;
    }
    if ($firstline) {
        print  FILE_OUT "// tree.js modified by genSQLDBCdoc\n";
        $firstline=0;
    }
#
#   Insert link for Native C Reference
#
    if ($_=~/\s+insDoc\(.*\"SQLDBC_C.h\".*\"(SQLDBC__C.*)\".*/){
        $sqldbc_c_ref = $1;
    }
    if ($_=~/\s+insDoc\(.*\"Compound Members\".*/){
        print  FILE_OUT "insDoc(foldersTree, gLnk(\"Native C Reference\", \"\", \"$sqldbc_c_ref\"))\n";
    }	      
#
#   Insert Installation chapter
#
    if ($_=~/\s+insDoc\(.*\"SQL Database Connectivity.*\".*/){
        print FILE_OUT $_;
        print FILE_OUT "insDoc(foldersTree, gLnk(\"Installation\", \"\", \"install.html\"))\n";
        next;
    }	          
    print FILE_OUT $_;
}

chdir("$ENV{OWN}/usr");

my $cmd = "tar -cvozf $package sdk/sqldbc/doc/* -T etc/HelloWorld.lst";
print "$cmd\n";
if (system($cmd)) {
    print "ERROR: '$cmd' failed. Can't pack documentation.\n";
    exit 1;    
}

if (! -d "$ENV{WRK}/fast/install" ) {
    mkdir ("$ENV{WRK}/fast/install", 0777);
}

File::Copy::copy("$package", "$ENV{WRK}/fast/install/$package") || die "Can't copy $package to $ENV{WRK}/fast/install/$package : $!";
print "Package $package copied to $ENV{WRK}/fast/install\n";

#
#   Append Examples chapter
#
printExamplesChapter(\*FILE_OUT);

#
#   Append License chapter
#
printLicenseChapter(\*FILE_OUT);

close(FILE_OUT); close(FILE_IN);

unlink "$infile";
rename "$outfile", "$infile";
exit 0;

sub checkDoxygenVersion
{
    my $doxygen=shift;
    my $doxyver=shift;
    if (-x "$doxygen") {
        my $ver="unknown";
        open(P1, "$doxygen -h |" ) || die "Can't open pipe '$doxygen -h' : $!\n";
        while(<P1>) {
            if (/Doxygen version (.*)$/) {
                $ver = $1;
            }
        }
        close(P1);
        if ("$ver" ne "$doxyver") {
            return 0;
        }
    }
    else {
        return 0;
    }
    return 1;
}

sub printLicenseChapter {
    my $fh = shift;
    print $fh "aux1 = insFld(foldersTree, gFld(\"License\", \"\", \"license.html\"))\n";
    if ($opt_with_floss) {
        print $fh "insDoc(aux1, gLnk(\"MaxDB FLOSS license exception\", \"\", \"FLOSS.html\"))\n";
    }
}

sub printExamplesChapter {
    my $fh = shift;
    print $fh "aux1 = insFld(foldersTree, gFld(\"Examples\", \"\", \"examples.html\"))\n";
}

sub usage() {
    print <DATA>;
    exit 1;
}

__DATA__

 USAGE: genSQLDBCdoc [-h] --dir=<path> [options]

           Patches the doxygen generated SQLDBC documnetation.

Options:  --dir=<path>    Path to the html doc tree
          --help          This help
 
          --with-floss    Includes FLOSS license exception
