#ifndef __OMS_CACHEMISSENTRY_HPP
#define __OMS_CACHEMISSENTRY_HPP

#include "Oms/OMS_CacheMissEntryDef.hpp"
#include "Oms/OMS_ContextDef.hpp"
#include "Oms/OMS_DbpError.hpp"
#include "SAPDBCommon/SAPDB_MemCopyMove.hpp"

/*----------------------------------------------------------------------*/
/* Implementation of class OMS_CacheMissEntry inline methods          */
/*----------------------------------------------------------------------*/

inline void OMS_CacheMissEntry::setKey (const unsigned char *key, int keyLen)
{
  if (key == NULL || keyLen <= 0){
    throw DbpError(DbpError::DB_ERROR, e_system_error, __MY_FILE__, __LINE__);
  }

  // Copy key
  SAPDB_MemCopyNoCheck(&m_key, key, keyLen);
}

//----------------------------------------------------------------------/

inline void* OMS_CacheMissEntry::operator new (size_t sz, 
                                               int keyLen, 
                                               OMS_Context* pContext)
{
  return pContext->allocate(sz + keyLen - 1);
}

//----------------------------------------------------------------------/

inline void OMS_CacheMissEntry::deleteSelf(OMS_Context* pContext)
{
   pContext->deallocate(this);
}

//----------------------------------------------------------------------/

#if defined(OMS_PLACEMENT_DELETE)
inline void OMS_CacheMissEntry::operator delete (void* p,
                                                 int keyLen,
                                                 OMS_Context* pContext)
{
  pContext->deallocate(p);
}
#endif

#endif // __OMS_CACHEMISSENTRY_HPP
